/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.service;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.ext.spring.service.ClassBasedServiceStrategy;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.service.AbstractReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceException;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.Lifecycle;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;

@ThreadSafe
public class ReloadableSpringService<T>
extends AbstractReloadableService<T>
implements ApplicationContextAware,
BeanNameAware,
Lifecycle {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ReloadableSpringService.class);
    @Nullable
    @NonnullElements
    private List<Resource> serviceConfigurations;
    @Nonnull
    @NonnullElements
    private List<BeanFactoryPostProcessor> factoryPostProcessors;
    @Nonnull
    @NonnullElements
    private List<BeanPostProcessor> postProcessors;
    @Nonnull
    private final Class<T> theClaz;
    @Nonnull
    private final Function<GenericApplicationContext, ServiceableComponent> serviceStrategy;
    @Nullable
    private ApplicationContext parentContext;
    @Nullable
    private String beanName;
    @Nullable
    private ServiceableComponent<T> cachedComponent;
    private boolean lastLoadFailed = true;
    @Nullable
    private long[] resourceLastModifiedTimes;

    public ReloadableSpringService(@Nonnull Class<T> claz) {
        this(claz, new ClassBasedServiceStrategy());
    }

    public ReloadableSpringService(@Nonnull Class<T> claz, @Nonnull Function<GenericApplicationContext, ServiceableComponent> strategy) {
        this.theClaz = (Class)Constraint.isNotNull(claz, (String)"Class cannot be null");
        this.serviceStrategy = (Function)Constraint.isNotNull(strategy, (String)"Strategy cannot be null");
        this.factoryPostProcessors = Collections.emptyList();
        this.postProcessors = Collections.emptyList();
    }

    @Nullable
    public ApplicationContext getParentContext() {
        return this.parentContext;
    }

    public void setParentContext(@Nullable ApplicationContext context) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.parentContext = context;
    }

    @Nonnull
    public List<Resource> getServiceConfigurations() {
        return this.serviceConfigurations;
    }

    public void setServiceConfigurations(@Nonnull @NonnullElements List<Resource> configs) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.serviceConfigurations = ImmutableList.builder().addAll(Iterables.filter(configs, (Predicate)Predicates.notNull())).build();
        if (!this.serviceConfigurations.isEmpty()) {
            this.resourceLastModifiedTimes = new long[this.serviceConfigurations.size()];
            int numOfResources = this.serviceConfigurations.size();
            for (int i = 0; i < numOfResources; ++i) {
                Resource serviceConfig = this.serviceConfigurations.get(i);
                try {
                    if (serviceConfig.exists()) {
                        this.resourceLastModifiedTimes[i] = serviceConfig.lastModified();
                        continue;
                    }
                    this.resourceLastModifiedTimes[i] = -1L;
                    continue;
                }
                catch (IOException e) {
                    this.log.info("{} Configuration resource '" + serviceConfig.getDescription() + "' last modification date could not be determined", (Object)this.getLogPrefix(), (Object)e);
                    this.resourceLastModifiedTimes[i] = -1L;
                }
            }
        } else {
            this.resourceLastModifiedTimes = null;
        }
    }

    public void setServiceConfigurationStrategy(@Nonnull Function<?, List<Resource>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        throw new UnsupportedOperationException("This UnsupportedOperationException method has not been implemented");
    }

    public void setBeanFactoryPostProcessors(@Nonnull @NonnullElements List<BeanFactoryPostProcessor> processors) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.factoryPostProcessors = new ArrayList<BeanFactoryPostProcessor>(Collections2.filter(processors, (Predicate)Predicates.notNull()));
    }

    public void setBeanPostProcessors(@Nonnull @NonnullElements List<BeanPostProcessor> processors) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.postProcessors = new ArrayList<BeanPostProcessor>(Collections2.filter(processors, (Predicate)Predicates.notNull()));
    }

    public final void start() {
        try {
            this.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new BeanInitializationException("Could not start service", (Throwable)e);
        }
    }

    public final void stop() {
        this.destroy();
    }

    public boolean isRunning() {
        return this.isInitialized() && !this.isDestroyed();
    }

    protected boolean shouldReload() {
        if (this.resourceLastModifiedTimes == null) {
            return false;
        }
        if (this.lastLoadFailed) {
            return true;
        }
        boolean configResourceChanged = false;
        int numOfResources = this.serviceConfigurations.size();
        for (int i = 0; i < numOfResources; ++i) {
            Resource serviceConfig = this.serviceConfigurations.get(i);
            try {
                if (this.resourceLastModifiedTimes[i] == -1L && !serviceConfig.exists()) {
                    this.log.debug("{} Resource remains unavailable/inaccessible: '{}'", (Object)this.getLogPrefix(), (Object)serviceConfig.getDescription());
                    continue;
                }
                if (this.resourceLastModifiedTimes[i] == -1L && serviceConfig.exists()) {
                    this.log.debug("{} Resource was unavailable, now present: '{}'", (Object)this.getLogPrefix(), (Object)serviceConfig.getDescription());
                    configResourceChanged = true;
                    this.resourceLastModifiedTimes[i] = serviceConfig.lastModified();
                    continue;
                }
                if (this.resourceLastModifiedTimes[i] > -1L && !serviceConfig.exists()) {
                    this.log.debug("{} Resource was available, now is not: '{}'", (Object)this.getLogPrefix(), (Object)serviceConfig.getDescription());
                    configResourceChanged = true;
                    this.resourceLastModifiedTimes[i] = -1L;
                    continue;
                }
                long serviceConfigLastModified = serviceConfig.lastModified();
                if (serviceConfigLastModified != this.resourceLastModifiedTimes[i]) {
                    this.log.debug("{} Resource has changed: '{}'", (Object)this.getLogPrefix(), (Object)serviceConfig.getDescription());
                    configResourceChanged = true;
                    this.resourceLastModifiedTimes[i] = serviceConfigLastModified;
                    continue;
                }
                this.log.trace("{} Resource has not changed '{}'", (Object)this.getLogPrefix(), (Object)serviceConfig.getDescription());
                continue;
            }
            catch (IOException e) {
                this.log.info("{} Configuration resource '{}' last modification date could not be determined", new Object[]{this.getLogPrefix(), serviceConfig.getDescription(), e});
                configResourceChanged = true;
            }
        }
        return configResourceChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReload() {
        ServiceableComponent<T> oldComponent;
        ServiceableComponent service;
        GenericApplicationContext appContext;
        super.doReload();
        this.log.debug("{} Creating new ApplicationContext for service '{}'", (Object)this.getLogPrefix(), (Object)this.getId());
        this.log.debug("{} Reloading from {}", (Object)this.getLogPrefix(), this.getServiceConfigurations());
        try {
            appContext = SpringSupport.newContext(this.getId(), this.getServiceConfigurations(), this.factoryPostProcessors, this.postProcessors, Collections.emptyList(), this.getParentContext());
        }
        catch (FatalBeanException e) {
            throw new ServiceException((Exception)((Object)e));
        }
        this.log.debug("{} New Application Context created for service '{}'", (Object)this.getLogPrefix(), (Object)this.getId());
        try {
            service = (ServiceableComponent)this.serviceStrategy.apply((Object)appContext);
        }
        catch (ServiceException e) {
            appContext.close();
            throw new ServiceException("Failed to load " + this.getServiceConfigurations(), (Exception)((Object)e));
        }
        service.pinComponent();
        Object theComponent = service.getComponent();
        this.log.debug("{} Testing that {} is a superclass of {}", new Object[]{this.getLogPrefix(), theComponent.getClass(), this.theClaz});
        if (!this.theClaz.isAssignableFrom(theComponent.getClass())) {
            service.unpinComponent();
            service.unloadComponent();
            throw new ServiceException("Class was not the same or a superclass of configured class");
        }
        ReloadableSpringService reloadableSpringService = this;
        synchronized (reloadableSpringService) {
            oldComponent = this.cachedComponent;
            this.cachedComponent = service;
            service.unpinComponent();
        }
        this.log.info("{} Completed reload and swapped in latest configuration for service '{}'", (Object)this.getLogPrefix(), (Object)this.getId());
        if (null != oldComponent) {
            this.log.debug("{} Unloading previous configuration for service '{}'", (Object)this.getLogPrefix(), (Object)this.getId());
            oldComponent.unloadComponent();
        }
        this.lastLoadFailed = false;
        this.log.info("{} Reload complete", (Object)this.getLogPrefix());
    }

    protected void doDestroy() {
        ServiceableComponent<T> oldComponent = this.cachedComponent;
        this.cachedComponent = null;
        if (null != oldComponent) {
            oldComponent.unloadComponent();
        }
    }

    public synchronized ServiceableComponent<T> getServiceableComponent() {
        if (null == this.cachedComponent) {
            return null;
        }
        this.cachedComponent.pinComponent();
        return this.cachedComponent;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.setParentContext(applicationContext);
    }

    public void setBeanName(@Nonnull @NotEmpty String name) {
        this.beanName = name;
    }

    protected void doInitialize() throws ComponentInitializationException {
        if (this.getId() == null) {
            this.setId(this.beanName);
        }
        super.doInitialize();
    }
}

