/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.resource;

import java.io.File;
import java.io.IOException;
import net.shibboleth.ext.spring.resource.FileBackedHTTPResource;
import net.shibboleth.ext.spring.resource.ResourceTestHelper;
import net.shibboleth.utilities.java.support.httpclient.HttpClientBuilder;
import org.apache.http.client.HttpClient;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class FileBackedHTTPResourceTest {
    private final String existsURL = "http://svn.shibboleth.net/view/utilities/spring-extensions/trunk/src/test/resources/data/document.xml?view=co";
    private final String nonExistsURL = "http://svn.shibboleth.net/view/utilities/spring-extensions/trunk/src/test/resources/data/documxent.xml?view=co";
    private String existsFile;
    private HttpClient client;

    @BeforeClass
    public void setupClient() throws Exception {
        this.client = new HttpClientBuilder().buildClient();
        File file = File.createTempFile("FileBackedHTTPResourceTest1", ".xml");
        this.existsFile = file.getAbsolutePath();
    }

    @AfterClass
    public void deleteFile() {
        File f = new File(this.existsFile);
        if (f.exists()) {
            f.delete();
        }
    }

    @Test
    public void existsTest() throws IOException {
        FileBackedHTTPResource existsResource = new FileBackedHTTPResource(this.client, "http://svn.shibboleth.net/view/utilities/spring-extensions/trunk/src/test/resources/data/document.xml?view=co", (Resource)new FileSystemResource(this.existsFile));
        FileBackedHTTPResource notExistsResource = new FileBackedHTTPResource(this.client, "http://svn.shibboleth.net/view/utilities/spring-extensions/trunk/src/test/resources/data/documxent.xml?view=co", (Resource)new FileSystemResource(this.existsFile + "ZZZ"));
        Assert.assertTrue((boolean)existsResource.exists());
        Assert.assertFalse((boolean)notExistsResource.exists());
    }

    @Test
    public void testCompare() throws IOException {
        Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)new FileBackedHTTPResource(this.client, "http://svn.shibboleth.net/view/utilities/spring-extensions/trunk/src/test/resources/data/document.xml?view=co", (Resource)new FileSystemResource(this.existsFile)), (Resource)new ClassPathResource("data/document.xml")));
        Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)new FileBackedHTTPResource(this.client, "http://svn.shibboleth.net/view/utilities/spring-extensions/trunk/src/test/resources/data/documxent.xml?view=co", (Resource)new FileSystemResource(this.existsFile)), (Resource)new ClassPathResource("data/document.xml")));
    }
}

