/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.factory;

import net.shibboleth.ext.spring.factory.DOMDocumentFactoryBean;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DOMDocumentFactoryBeanTest {
    @Test
    public void getObject() throws Exception {
        DOMDocumentFactoryBean factory = new DOMDocumentFactoryBean();
        ClassPathResource resource = new ClassPathResource("data/document.xml");
        BasicParserPool pool = new BasicParserPool();
        pool.initialize();
        factory.setResource((Resource)resource);
        factory.setParserPool((ParserPool)pool);
        Document doc = factory.getObject();
        Element element = doc.getDocumentElement();
        Assert.assertEquals((String)element.getLocalName(), (String)"docElement");
        Assert.assertEquals((boolean)factory.isSingleton(), (boolean)true, (String)"singleton assertion");
        Document doc2 = factory.getObject();
        Assert.assertEquals((Object)doc2, (Object)doc, (String)"singleton equality");
    }

    @Test
    public void getObjectType() {
        DOMDocumentFactoryBean factory = new DOMDocumentFactoryBean();
        Assert.assertEquals((Object)factory.getObjectType(), Document.class, (String)"object type");
    }
}

