/*
 * Decompiled with CFR 0.152.
 */
package zen.xml;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import zen.string.StringUtility;
import zen.xml.XmlDocument;
import zen.xml.XmlException;
import zen.xml.XmlNode;

public final class XmlWriter {
    private XmlWriter() {
    }

    public static void write(XmlDocument xmlDocument, String path) throws XmlException {
        XmlWriter.write(xmlDocument, new File(path));
    }

    public static void write(XmlDocument xmlDocument, File file) throws XmlException {
        Document document = XmlWriter.getDocument();
        XmlNode node = xmlDocument.getRoot();
        Element element = document.createElement(node.getName());
        XmlWriter.setElement(document, element, node);
        document.appendChild(element);
        if (node.getChildren() != null) {
            XmlWriter.setChildren(document, element, node);
        }
        XmlWriter.transform(document, file);
    }

    private static void transform(Document document, File file) throws XmlException {
        try {
            Transformer transformer = XmlWriter.getTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(file);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(source, result);
        }
        catch (TransformerException exception) {
            throw new XmlException(exception);
        }
    }

    private static void setElement(Document document, Element element, XmlNode node) {
        if (!StringUtility.isEmpty(node.getValue())) {
            element.appendChild(document.createTextNode(node.getValue()));
        }
        for (String name : node.getAttributeNames()) {
            element.setAttribute(name, node.getAttribute(name));
        }
    }

    private static void setChildren(Document document, Element parent, XmlNode node) {
        for (XmlNode child : node.getChildren()) {
            Element element = document.createElement(child.getName());
            XmlWriter.setElement(document, element, child);
            parent.appendChild(element);
            if (child.getChildren() == null) continue;
            XmlWriter.setChildren(document, element, child);
        }
    }

    private static Transformer getTransformer() throws XmlException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            return factory.newTransformer();
        }
        catch (TransformerConfigurationException exception) {
            throw new XmlException(exception);
        }
    }

    private static Document getDocument() throws XmlException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.newDocument();
        }
        catch (ParserConfigurationException exception) {
            throw new XmlException(exception);
        }
    }
}

