/*
 * Decompiled with CFR 0.152.
 */
package zen.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import zen.file.FileException;
import zen.file.FileUtility;
import zen.xml.XmlDocument;
import zen.xml.XmlException;
import zen.xml.XmlNode;

public final class XmlParser {
    private XmlParser() {
    }

    public static void load(File file, XmlDocument document) throws XmlException {
        XmlParser.load(XmlParser.getDocumentRoot(file), document);
    }

    public static void load(InputStream stream, XmlDocument document) throws XmlException {
        XmlParser.load(XmlParser.getDocumentRoot(stream), document);
    }

    public static void load(String file, XmlDocument document) throws XmlException {
        XmlParser.load(XmlParser.getDocumentRoot(file), document);
    }

    public static void load(StringBuffer input, XmlDocument document) throws XmlException {
        XmlParser.load(XmlParser.getDocumentRoot(input), document);
    }

    private static void load(Element root, XmlDocument document) throws XmlException {
        document.setRoot(new XmlNode());
        XmlParser.parse(root, document.getRoot());
    }

    private static Element getDocumentRoot(InputStream stream) throws XmlException {
        return XmlParser.getDocumentRoot(new InputSource(stream));
    }

    private static Element getDocumentRoot(StringBuffer input) throws XmlException {
        return XmlParser.getDocumentRoot(new InputSource(new StringReader(input.toString())));
    }

    private static Element getDocumentRoot(String file) throws XmlException {
        try {
            return XmlParser.getDocumentRoot(FileUtility.getStream(file));
        }
        catch (FileException exception) {
            throw new XmlException("Not able to get document root element for File [" + file + "]", exception);
        }
    }

    private static Element getDocumentRoot(File file) throws XmlException {
        try {
            return XmlParser.getDocumentRoot(new InputSource(new FileReader(file)));
        }
        catch (FileNotFoundException exception) {
            throw new XmlException("Not able to get document root element for File [" + file.getPath() + "]", exception);
        }
    }

    private static Element getDocumentRoot(InputSource source) throws XmlException {
        try {
            DOMParser parser = new DOMParser();
            parser.parse(source);
            Document document = parser.getDocument();
            return document.getDocumentElement();
        }
        catch (SAXException exception) {
            throw new XmlException("Unable to parse the input source with SAX", exception);
        }
        catch (IOException exception) {
            throw new XmlException("Unable to read the input source from the stream", exception);
        }
    }

    private static void parse(Node node, XmlNode xmlNode) {
        if (node != null) {
            xmlNode.setName(node.getNodeName().trim());
            if (node.getFirstChild() != null) {
                xmlNode.setValue(node.getFirstChild().getNodeValue());
            }
            XmlParser.setAttributes(node, xmlNode);
            XmlParser.setChildren(node, xmlNode);
        }
    }

    private static void setAttributes(Node node, XmlNode xmlNode) {
        NamedNodeMap map = node.getAttributes();
        int i = 0;
        while (map != null && i < map.getLength()) {
            Node attribute = map.item(i);
            xmlNode.setAttribute(attribute.getNodeName().trim(), attribute.getNodeValue().trim());
            ++i;
        }
    }

    private static void setChildren(Node node, XmlNode xmlNode) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (children != null && i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeName().trim().equals("#text")) {
                if (node.getNodeValue() != null) {
                    xmlNode.setValue(node.getNodeValue().trim());
                }
            } else {
                XmlNode xmlChild = new XmlNode();
                xmlNode.addChild(xmlChild);
                XmlParser.parse(child, xmlChild);
            }
            ++i;
        }
    }
}

