/*
 * Decompiled with CFR 0.152.
 */
package zen.xml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class XmlNode
implements Serializable {
    private static final long serialVersionUID = -7265125702721282800L;
    private String name;
    private String value;
    private final transient Map<String, String> attributes = new HashMap<String, String>();
    private final transient List<XmlNode> children = new ArrayList<XmlNode>();

    public XmlNode() {
    }

    public XmlNode(String name) {
        this.name = name;
    }

    public XmlNode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public String getAttribute(String name) {
        if (this.attributes.containsKey(name)) {
            return this.attributes.get(name);
        }
        return null;
    }

    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public void addChild(XmlNode node) {
        this.children.add(node);
    }

    public XmlNode getChild(String name) {
        List<XmlNode> children = this.getChildren(name);
        if (!children.isEmpty()) {
            return children.get(0);
        }
        return null;
    }

    public List<XmlNode> getChildren() {
        return this.children;
    }

    public List<XmlNode> getChildren(String name) {
        ArrayList<XmlNode> list = new ArrayList<XmlNode>();
        int i = 0;
        while (i < this.children.size()) {
            XmlNode node = this.children.get(i);
            if (node.getName().equals(name)) {
                list.add(node);
            }
            ++i;
        }
        return list;
    }
}

