/*
 * Decompiled with CFR 0.152.
 */
package zen.xml;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import zen.xml.XmlException;
import zen.xml.XmlNode;
import zen.xml.XmlParser;

public class XmlDocument
implements Serializable {
    private static final long serialVersionUID = -4944215480661086249L;
    private XmlNode root;

    public XmlDocument() {
    }

    public XmlDocument(File file) throws XmlException {
        XmlParser.load(file, this);
    }

    public XmlDocument(InputStream stream) throws XmlException {
        XmlParser.load(stream, this);
    }

    public XmlDocument(String file) throws XmlException {
        XmlParser.load(file, this);
    }

    public XmlDocument(StringBuffer input) throws XmlException {
        XmlParser.load(input, this);
    }

    public void setRoot(XmlNode root) {
        this.root = root;
    }

    public XmlNode getRoot() {
        return this.root;
    }

    public XmlNode getNode(String nodeName) throws XmlException {
        List<XmlNode> nodes = this.getNodes(nodeName);
        if (nodes.size() == 1) {
            return nodes.get(0);
        }
        throw new XmlException("More than one Node [" + nodeName + "] found on Document [" + this.getRoot().getName() + "]. Only one was expected.");
    }

    public List<XmlNode> getNodes(String nodeName) throws XmlException {
        ArrayList<XmlNode> found = new ArrayList<XmlNode>();
        this.findNodes(this.getRoot(), nodeName, found);
        if (found.isEmpty()) {
            throw new XmlException("Node [" + nodeName + "] not found on Document [" + this.getRoot().getName() + "]");
        }
        return found;
    }

    private void findNodes(XmlNode xmlNode, String nodeName, List<XmlNode> found) {
        List<XmlNode> nodes = xmlNode.getChildren();
        int i = 0;
        while (i < nodes.size()) {
            XmlNode node = nodes.get(i);
            if (node.getName().equals(nodeName)) {
                found.add(node);
            } else {
                this.findNodes(node, nodeName, found);
            }
            ++i;
        }
    }
}

