/*
 * Decompiled with CFR 0.152.
 */
package zen.validation.implementations;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import zen.string.StringUtility;
import zen.validation.abstracts.AbstractValidation;

public class Date
extends AbstractValidation {
    public static final String FORMAT = "format";
    private static final String DEFAULT_FORMAT = Date.getDefaultFormat();

    @Override
    public boolean isValid(String value) {
        String format = this.getParamValue(FORMAT);
        if (StringUtility.isEmpty(format)) {
            format = DEFAULT_FORMAT;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.US);
        try {
            sdf.parse(value);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    private static String getDefaultFormat() {
        return "MM/dd/yyyy";
    }
}

