/*
 * Decompiled with CFR 0.152.
 */
package zen.validation.abstracts;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zen.logging.interfaces.ILogging;
import zen.string.StringUtility;
import zen.validation.interfaces.IValidation;

public abstract class AbstractValidation
implements IValidation,
ILogging {
    private final transient Map<String, String> ruleParams = new HashMap<String, String>();

    protected AbstractValidation() {
    }

    @Override
    public abstract boolean isValid(String var1);

    public void addParam(String name, String value) {
        if (!StringUtility.isEmpty(name)) {
            this.ruleParams.put(name, value);
        }
    }

    protected Iterator<String> getParamNames() {
        return this.ruleParams.keySet().iterator();
    }

    protected String getParamValue(String paramName) {
        return this.ruleParams.get(paramName);
    }

    protected boolean matches(String regex, String value) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(value);
        return matcher.matches();
    }
}

