/*
 * Decompiled with CFR 0.152.
 */
package zen.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import zen.common.Message;
import zen.logging.interfaces.ILogging;
import zen.object.ObjectException;
import zen.object.ObjectUtility;
import zen.string.StringUtility;
import zen.validation.MappingNotFoundException;
import zen.validation.ObjectMapping;
import zen.validation.RuleNotFoundException;
import zen.validation.ValidationDefinition;
import zen.validation.ValidationFactory;
import zen.validation.ValidationMapping;
import zen.validation.abstracts.AbstractValidation;

public final class Validator
implements ILogging {
    private static final String PARENT_EQUAL = "PARENT_EQUAL";
    private static final String PARENT_NOT_EQUAL = "PARENT_NOT_EQUAL";
    private static final String IF_THIS_EMPTY = "IF_THIS_EMPTY";
    private static final String IF_THIS_NOT_EMPTY = "IF_THIS_NOT_EMPTY";

    private Validator() {
    }

    public static List<Message> validate(String application, Object object) {
        return Validator.validate(application, null, null, object);
    }

    public static List<Message> validate(String application, String optkey, String validationSet, Object object) {
        ArrayList<Message> messages = new ArrayList<Message>();
        if (object == null) {
            return messages;
        }
        try {
            LOG.info(Validator.class, "Get Validation Mapping by application name...");
            ValidationMapping vmapping = ValidationFactory.getInstance().getValidationMapping(application);
            LOG.info(Validator.class, "Get specific validation mapping for this object[" + object.getClass().getName() + "]...");
            if (vmapping == null) {
                LOG.warn(Validator.class, "Could not find validation mapping for application '" + (application == null ? "null" : application) + "'");
            } else {
                Validator.getObjectMapping(vmapping, optkey, validationSet, object, messages);
            }
        }
        catch (MappingNotFoundException exception) {
            LOG.error(Validator.class, "MappingNotFoundException: " + exception.getLocalizedMessage(), exception);
        }
        return messages;
    }

    private static void getObjectMapping(ValidationMapping vmapping, String optkey, String validationSet, Object object, List<Message> messages) throws MappingNotFoundException {
        ObjectMapping omapping = null;
        omapping = StringUtility.isEmpty(optkey) ? vmapping.getMapping(object.getClass().getName()) : vmapping.getMapping(optkey);
        if (omapping == null) {
            LOG.warn(Validator.class, "Could not find object mapping for " + (StringUtility.isEmpty(optkey) ? "object '" + object.getClass().getName() : "optkey: " + optkey) + "'");
        } else {
            Validator.getDefinitions(omapping, vmapping, validationSet, object, messages);
        }
    }

    private static void getDefinitions(ObjectMapping omapping, ValidationMapping vmapping, String validationSet, Object object, List<Message> messages) {
        List<ValidationDefinition> definitions = null;
        definitions = StringUtility.isEmpty(validationSet) ? omapping.getDefinitions() : omapping.getDefinitions(validationSet);
        if (definitions != null) {
            LOG.info(Validator.class, "Run the validation rules....");
            Validator.processDefinitions(object, vmapping, definitions, messages, null);
        }
    }

    protected static void processDefinitions(Object object, ValidationMapping mapping, List<ValidationDefinition> definitions, List<Message> messages, ValidationDefinition parentDefinition) {
        for (ValidationDefinition definition : definitions) {
            String property = null;
            property = parentDefinition == null ? definition.getProperty() : parentDefinition.getProperty();
            String value = Validator.getValue(object, property);
            Validator.executeDefinition(object, mapping, definition, messages, property, value);
        }
    }

    private static void executeDefinition(Object object, ValidationMapping mapping, ValidationDefinition definition, List<Message> messages, String parentPropName, String parentPropValue) {
        try {
            String property = Validator.getProperty(definition, parentPropName);
            String value = Validator.getValue(object, property);
            Message message = new Message(definition.getMessage(), definition.getParameters());
            boolean proceed = Validator.getProceed(value, definition.getRuleName(), parentPropValue, mapping, messages, message);
            if (proceed) {
                List<ValidationDefinition> dependencies = definition.getDependencies();
                Validator.processDefinitions(object, mapping, dependencies, messages, definition);
            }
        }
        catch (RuleNotFoundException e) {
            LOG.error(Validator.class, "This Rule [" + definition.getRuleName() + "] does not exist in the rules mappings", e);
        }
    }

    private static boolean getProceed(String value, String ruleName, String parentPropValue, ValidationMapping mapping, List<Message> messages, Message message) throws RuleNotFoundException {
        boolean proceed = true;
        if (ruleName.equals(IF_THIS_EMPTY)) {
            proceed = StringUtility.isEmpty(value);
        } else if (ruleName.equals(IF_THIS_NOT_EMPTY)) {
            proceed = !StringUtility.isEmpty(value);
        } else if (ruleName.equals(PARENT_EQUAL)) {
            if (!value.equals(parentPropValue)) {
                proceed = false;
                messages.add(message);
            }
        } else if (ruleName.equals(PARENT_NOT_EQUAL)) {
            if (value.equals(parentPropValue)) {
                proceed = false;
                messages.add(message);
            }
        } else {
            AbstractValidation validation = mapping.getRule(ruleName);
            if (!validation.isValid(value)) {
                proceed = false;
                messages.add(message);
            }
        }
        return proceed;
    }

    private static String getProperty(ValidationDefinition definition, String parentPropName) {
        if (StringUtility.isEmpty(definition.getProperty())) {
            return parentPropName;
        }
        return definition.getProperty();
    }

    private static String getValue(Object object, String property) {
        Class<?> clazz = object.getClass();
        String value = null;
        try {
            while (clazz != null) {
                if (clazz.getName().equals("org.apache.struts.action.DynaActionForm")) {
                    Map map = (Map)ObjectUtility.getMethodValue(object, "map");
                    value = (String)map.get(property);
                    break;
                }
                clazz = clazz.getSuperclass();
            }
            if (clazz == null) {
                value = (String)ObjectUtility.getMethodValue(object, property);
            }
        }
        catch (ObjectException e) {
            LOG.error(Validator.class, "Error getting value for Property [" + property + "]", e);
        }
        return value;
    }
}

