/*
 * Decompiled with CFR 0.152.
 */
package zen.validation;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import zen.logging.interfaces.ILogging;
import zen.validation.MappingNotFoundException;
import zen.validation.MappingUtility;
import zen.validation.ObjectMapping;
import zen.validation.RuleNotFoundException;
import zen.validation.abstracts.AbstractValidation;
import zen.xml.XmlDocument;
import zen.xml.XmlNode;

public class ValidationMapping
implements Serializable,
ILogging {
    private static final long serialVersionUID = -8296981239058594647L;
    private static final String RULES = "rules";
    private static final String RULE = "rule";
    private static final String MAPPINGS = "mappings";
    private static final String MAPPING = "mapping";
    private final transient Map<String, AbstractValidation> rules = new HashMap<String, AbstractValidation>();
    private final transient Map<String, ObjectMapping> objects = new HashMap<String, ObjectMapping>();

    public ValidationMapping(String file) {
        try {
            XmlDocument document = new XmlDocument(file);
            XmlNode root = document.getRoot();
            XmlNode rnodes = root.getChild(RULES);
            XmlNode mnodes = root.getChild(MAPPINGS);
            MappingUtility.addRules(this.rules, rnodes.getChildren(RULE));
            MappingUtility.addMappings(this.objects, mnodes.getChildren(MAPPING));
        }
        catch (Exception exception) {
            LOG.error(ValidationMapping.class, exception.toString(), exception);
        }
    }

    public AbstractValidation getRule(String name) throws RuleNotFoundException {
        if (this.rules.containsKey(name)) {
            return this.rules.get(name);
        }
        throw new RuleNotFoundException("Rule [" + name + "] Not Found");
    }

    public ObjectMapping getMapping(String name) throws MappingNotFoundException {
        if (this.objects.containsKey(name)) {
            return this.objects.get(name);
        }
        throw new MappingNotFoundException("Mapping for Object [" + name + "] Not Found");
    }
}

