/*
 * Decompiled with CFR 0.152.
 */
package zen.validation;

import java.util.HashMap;
import java.util.Map;
import zen.common.AbstractFactory;
import zen.configuration.ConfigurationException;
import zen.configuration.ConfigurationReader;
import zen.validation.Configuration;
import zen.validation.Configurations;
import zen.validation.ValidationMapping;

public final class ValidationFactory
extends AbstractFactory {
    private static final long serialVersionUID = 1301702902802834345L;
    private static ValidationFactory instance;
    private final transient Map<String, ValidationMapping> mappings = new HashMap<String, ValidationMapping>();

    private ValidationFactory() {
        try {
            Configurations configurations = (Configurations)ConfigurationReader.loadConfigurations(Configurations.class);
            for (Configuration configuration : configurations.getConfigurations()) {
                this.mappings.put(configuration.getName(), this.getValidationMapping(configuration));
            }
        }
        catch (ConfigurationException e) {
            LOG.error(ValidationFactory.class, "ConfigurationException: " + e.getLocalizedMessage(), e);
        }
    }

    private ValidationMapping getValidationMapping(Configuration configuration) {
        return new ValidationMapping(configuration.getFile());
    }

    public static ValidationFactory getInstance() {
        if (instance == null) {
            instance = new ValidationFactory();
        }
        return instance;
    }

    public ValidationMapping getValidationMapping(String application) {
        if (this.mappings.containsKey(application)) {
            return this.mappings.get(application);
        }
        return null;
    }
}

