/*
 * Decompiled with CFR 0.152.
 */
package zen.validation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import zen.logging.interfaces.ILogging;
import zen.validation.MappingUtility;
import zen.validation.ValidationDefinition;
import zen.xml.XmlException;

public class ObjectMapping
implements Serializable,
ILogging {
    private static final long serialVersionUID = -6943873183844776182L;
    private String object = null;
    private final transient Map<String, ArrayList<ValidationDefinition>> definitions = new HashMap<String, ArrayList<ValidationDefinition>>();

    public ObjectMapping(String object, String resource) {
        this.object = object;
        try {
            MappingUtility.getDefinitions(resource, this.definitions);
        }
        catch (XmlException e) {
            LOG.error(ObjectMapping.class, e.toString(), e);
        }
    }

    public boolean hasDefinitions(String set) {
        return this.definitions.containsKey(set);
    }

    public List<ValidationDefinition> getDefinitions() {
        return this.getDefinitions("");
    }

    public List<ValidationDefinition> getDefinitions(String set) {
        return this.definitions.get(set);
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }
}

