/*
 * Decompiled with CFR 0.152.
 */
package zen.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import zen.object.ObjectException;
import zen.object.ObjectUtility;
import zen.string.StringUtility;
import zen.validation.ObjectMapping;
import zen.validation.ValidationDefinition;
import zen.validation.abstracts.AbstractValidation;
import zen.xml.XmlDocument;
import zen.xml.XmlException;
import zen.xml.XmlNode;

public final class MappingUtility {
    private static final String SET = "set";
    private static final String PROPERTY = "property";
    private static final String MESSAGE = "message";
    private static final String PARAMETERS = "parameters";
    private static final String VALIDATION = "validation";
    private static final String RULE = "rule";
    private static final String RULE_PARAM = "param";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String OPTKEY = "optkey";
    private static final String OBJECT = "object";
    private static final String RESOURCE = "resource";

    private MappingUtility() {
    }

    public static void getDefinitions(String resource, Map<String, ArrayList<ValidationDefinition>> definitions) throws XmlException {
        XmlDocument document = new XmlDocument(resource);
        XmlNode root = document.getRoot();
        List<XmlNode> nodes = root.getChildren(VALIDATION);
        MappingUtility.addDefinitions(definitions, "", nodes);
        List<XmlNode> sets = root.getChildren(SET);
        int i = 0;
        while (i < sets.size()) {
            XmlNode setNode = sets.get(i);
            String set = setNode.getAttribute("key");
            nodes = setNode.getChildren(VALIDATION);
            MappingUtility.addDefinitions(definitions, set, nodes);
            ++i;
        }
    }

    public static void addDefinitions(Map<String, ArrayList<ValidationDefinition>> definitions, String set, List<XmlNode> nodes) {
        for (XmlNode node : nodes) {
            MappingUtility.addDefinition(definitions, set, MappingUtility.getValidationDefinition(node));
        }
    }

    private static ValidationDefinition getValidationDefinition(XmlNode node) {
        ValidationDefinition definition = new ValidationDefinition();
        definition.setProperty(node.getAttribute(PROPERTY));
        definition.setRuleName(node.getAttribute(RULE));
        definition.setMessage(node.getAttribute(MESSAGE));
        String parameters = node.getAttribute(PARAMETERS);
        if (!StringUtility.isEmpty(parameters)) {
            definition.setParameters(StringUtility.split(parameters, ","));
        }
        for (XmlNode child : node.getChildren(VALIDATION)) {
            definition.addDependency(MappingUtility.getValidationDefinition(child));
        }
        return definition;
    }

    public static void addDefinition(Map<String, ArrayList<ValidationDefinition>> definitions, ValidationDefinition definition) {
        MappingUtility.addDefinition(definitions, "", definition);
    }

    public static void addDefinition(Map<String, ArrayList<ValidationDefinition>> definitions, String set, ValidationDefinition definition) {
        if (definitions.containsKey(set)) {
            ArrayList<ValidationDefinition> defs = definitions.get(set);
            defs.add(definition);
        } else {
            ArrayList<ValidationDefinition> defs = new ArrayList<ValidationDefinition>();
            defs.add(definition);
            definitions.put(set, defs);
        }
    }

    public static void addRules(Map<String, AbstractValidation> rules, List<XmlNode> nodes) throws ObjectException {
        for (XmlNode node : nodes) {
            String name = node.getAttribute(NAME);
            String type = node.getAttribute(TYPE);
            AbstractValidation validation = (AbstractValidation)ObjectUtility.createInstance(type);
            for (XmlNode paramNode : node.getChildren(RULE_PARAM)) {
                String paramName = paramNode.getAttribute(NAME);
                String paramValue = paramNode.getAttribute(VALUE);
                validation.addParam(paramName, paramValue);
            }
            rules.put(name, validation);
        }
    }

    public static void addMappings(Map<String, ObjectMapping> objects, List<XmlNode> nodes) {
        for (XmlNode node : nodes) {
            MappingUtility.addMapping(objects, node);
        }
    }

    private static void addMapping(Map<String, ObjectMapping> objects, XmlNode node) {
        String object = node.getAttribute(OBJECT);
        String optkey = node.getAttribute(OPTKEY);
        if (StringUtility.isEmpty(optkey)) {
            optkey = object;
        }
        String resource = node.getAttribute(RESOURCE);
        ObjectMapping mapping = new ObjectMapping(object, resource);
        objects.put(optkey, mapping);
    }
}

