/*
 * Decompiled with CFR 0.152.
 */
package zen.system;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import zen.logging.interfaces.ILogging;
import zen.system.Feedback;

public final class SystemUtility
implements ILogging {
    private SystemUtility() {
    }

    public static Feedback execute(String command) {
        Feedback feedback = new Feedback();
        try {
            LOG.info(SystemUtility.class, "#### Command: " + command);
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(command);
            SystemUtility.feedback(feedback.getInput(), process.getInputStream());
            SystemUtility.feedback(feedback.getError(), process.getErrorStream());
            process.waitFor();
        }
        catch (IOException exception) {
            SystemUtility.addError(feedback, exception);
        }
        catch (InterruptedException exception) {
            SystemUtility.addError(feedback, exception);
        }
        return feedback;
    }

    private static void feedback(List<String> lines, InputStream input) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        String line = null;
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        reader.close();
    }

    private static void addError(Feedback feedback, Throwable throwable) {
        feedback.getError().add(throwable.toString());
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            feedback.getError().add("*** " + element.toString());
            ++n2;
        }
        if (throwable.getCause() != null) {
            SystemUtility.addError(feedback, throwable.getCause());
        }
    }
}

