/*
 * Decompiled with CFR 0.152.
 */
package zen.string;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import zen.utility.Utility;

public final class StringUtility
extends Utility {
    private static final String[] TRUES = new String[]{"TRUE", "T", "YES", "Y", "1"};
    private static final String[] FALSES = new String[]{"FALSE", "F", "NO", "N", "0"};

    private StringUtility() {
    }

    public static String replace(String string, String oldValue, String newValue) {
        String front = string.substring(0, string.indexOf(oldValue));
        String back = string.substring(string.indexOf(oldValue) + oldValue.length(), string.length());
        return String.valueOf(front) + newValue + back;
    }

    public static boolean getBooleanValue(String string) {
        if (StringUtility.isEmpty(string)) {
            return false;
        }
        String value = string.trim().toUpperCase(Locale.US);
        String[] stringArray = TRUES;
        int n = TRUES.length;
        int n2 = 0;
        while (n2 < n) {
            String tvalue = stringArray[n2];
            if (value.equals(tvalue)) {
                return true;
            }
            ++n2;
        }
        stringArray = FALSES;
        n = FALSES.length;
        n2 = 0;
        while (n2 < n) {
            String fvalue = stringArray[n2];
            if (value.equals(fvalue)) {
                return false;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    public static String[] split(String value, String delim) {
        List<String> elements;
        String thisDelim = delim;
        if (thisDelim == null) {
            thisDelim = " ";
        }
        if (value != null && (elements = StringUtility.splitAsList(value, thisDelim)) != null) {
            String[] tokens = new String[elements.size()];
            int i = 0;
            while (i < elements.size()) {
                tokens[i] = elements.get(i);
                ++i;
            }
            return tokens;
        }
        return new String[0];
    }

    public static List<String> splitAsList(String value, String delim) {
        String thisDelim = delim;
        if (thisDelim == null) {
            thisDelim = " ";
        }
        if (value != null) {
            ArrayList<String> elements = new ArrayList<String>();
            int start = 0;
            int index = -1;
            while ((index = value.indexOf(thisDelim, start)) != -1) {
                elements.add(value.substring(start, index).trim());
                start = index + thisDelim.length();
            }
            elements.add(value.substring(start, value.length()).trim());
            return elements;
        }
        return Collections.emptyList();
    }

    public static String convertListToDelimitedString(List<String> list, String delim) {
        StringBuffer value = new StringBuffer(100);
        if (list != null) {
            for (String string : list) {
                if (!StringUtility.isEmpty(value.toString())) {
                    value.append(delim);
                }
                value.append(string);
            }
        }
        return value.toString();
    }

    public static String convertArrayToDelimitedString(String[] list, String delim) {
        StringBuffer value = new StringBuffer(100);
        if (list != null) {
            String[] stringArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (!StringUtility.isEmpty(value.toString())) {
                    value.append(delim);
                }
                value.append(string);
                ++n2;
            }
        }
        return value.toString();
    }

    public static String getASCII(String value) {
        StringBuffer ascii = new StringBuffer(100);
        int i = 0;
        while (i < value.length()) {
            ascii.append("[" + value.charAt(i) + "]");
            ++i;
        }
        return ascii.toString();
    }
}

