/*
 * Decompiled with CFR 0.152.
 */
package zen.scm.implementations.svn;

import java.util.Calendar;
import java.util.Date;
import zen.date.DateUtility;
import zen.scm.CommandException;
import zen.scm.enums.Change;
import zen.scm.enums.Kind;
import zen.scm.objects.ProfileObject;
import zen.string.StringUtility;
import zen.system.Feedback;
import zen.system.SystemUtility;
import zen.utility.Utility;

public final class SvnUtility
extends Utility {
    private SvnUtility() {
    }

    public static Kind getKind(String value) {
        Kind kind = null;
        if (!StringUtility.isEmpty(value)) {
            if ("file".equals(value)) {
                kind = Kind.FILE;
            } else if ("dir".equals(value)) {
                kind = Kind.DIRECTORY;
            }
        }
        return kind;
    }

    public static Change getChange(String value) {
        Change change = null;
        if (!StringUtility.isEmpty(value)) {
            if ("A".equals(value)) {
                change = Change.ADDED;
            } else if ("D".equals(value)) {
                change = Change.DELETED;
            } else if ("M".equals(value)) {
                change = Change.MODIFIED;
            } else if ("R".equals(value)) {
                change = Change.REPLACED;
            }
        }
        return change;
    }

    public static Date getSVNFormattedDate(String value) {
        Date date = null;
        if (!StringUtility.isEmpty(value)) {
            int index1 = value.indexOf(84);
            int index2 = value.indexOf(46);
            StringBuffer buffer = new StringBuffer();
            buffer.append(value.substring(0, index1));
            buffer.append(' ');
            buffer.append(value.substring(index1 + 1, index2));
            date = DateUtility.parse("yyyy-MM-dd HH:mm:ss", buffer.toString());
        }
        return date;
    }

    public static Date getFormattedDate(String line) throws CommandException {
        String[] elements = StringUtility.split(line.trim(), " ");
        String datetime = String.valueOf(elements[0].trim()) + " " + elements[1].trim();
        return DateUtility.parse("yyyy-MM-dd HH:mm:ss", datetime);
    }

    public static String getDateArguments(Date date1, Date date2) {
        return "{" + SvnUtility.getDate(date1) + "}" + ":" + "{" + SvnUtility.getAdjustedDate(date2) + "}";
    }

    public static String getDate(Date date) {
        return DateUtility.format("yyyy-MM-dd", date);
    }

    public static String getAdjustedDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        return DateUtility.format("yyyy-MM-dd", calendar.getTime());
    }

    public static Feedback runSvnCommand(ProfileObject profile, String command) {
        StringBuffer statement = new StringBuffer();
        statement.append("svn");
        statement.append(" ");
        statement.append("--username");
        statement.append(" ");
        statement.append(profile.getUsername());
        statement.append(" ");
        statement.append("--password");
        statement.append(" ");
        statement.append(profile.getPassword());
        statement.append(" ");
        statement.append(command);
        return SystemUtility.execute(statement.toString());
    }

    public static Feedback getSvnLookCommand(String command) {
        StringBuffer statement = new StringBuffer();
        statement.append("svnlook");
        statement.append(" ");
        statement.append(command);
        Feedback feedback = SystemUtility.execute(statement.toString());
        if (feedback.isError()) {
            LOG.error(SvnUtility.class, "svnlook does not work on this computer");
        }
        return feedback;
    }

    public static Feedback getSvnAdminCommand(String command) {
        StringBuffer statement = new StringBuffer();
        statement.append("svnadmin");
        statement.append(" ");
        statement.append(command);
        Feedback feedback = SystemUtility.execute(statement.toString());
        if (feedback.isError()) {
            LOG.error(SvnUtility.class, "svnadmin does not work on this computer");
        }
        return feedback;
    }
}

