/*
 * Decompiled with CFR 0.152.
 */
package zen.scm.implementations.svn;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import zen.scm.CommandException;
import zen.scm.abstracts.AbstractLogCommand;
import zen.scm.implementations.svn.SvnUtility;
import zen.scm.objects.ChangeObject;
import zen.scm.objects.ProfileObject;
import zen.scm.objects.RevisionObject;
import zen.string.StringUtility;
import zen.system.Feedback;
import zen.xml.XmlDocument;
import zen.xml.XmlException;
import zen.xml.XmlNode;

public class SVNLogCommand
extends AbstractLogCommand {
    private static final String LOG = "log --xml";
    private static final String STOP_ON_COPY = "--stop-on-copy";
    private static final String USE_MERGE_HISTORY = "--use-merge-history";
    private static final String CHANGED = "changed";
    private static final String REVISION = "-r";

    public SVNLogCommand(ProfileObject profile) {
        super(profile);
    }

    @Override
    public List<RevisionObject> revisions(String path, boolean stopOnCopy, boolean useMergeHistory) throws CommandException {
        StringBuffer command = new StringBuffer();
        command.append(this.getLogCommand(stopOnCopy, useMergeHistory));
        command.append(" ");
        command.append(path);
        return this.getRevisions(path, command.toString());
    }

    @Override
    public List<RevisionObject> revisions(String path, Long revision, boolean stopOnCopy, boolean useMergeHistory) throws CommandException {
        StringBuffer command = new StringBuffer();
        command.append(this.getLogCommand(stopOnCopy, useMergeHistory));
        command.append(" ");
        command.append(path);
        command.append(" ");
        command.append(REVISION);
        command.append(" ");
        command.append(revision);
        return this.getRevisions(path, command.toString());
    }

    @Override
    public List<RevisionObject> revisions(String path, Long fromRevision, Long toRevision, boolean stopOnCopy, boolean useMergeHistory) throws CommandException {
        StringBuffer command = new StringBuffer();
        command.append(this.getLogCommand(stopOnCopy, useMergeHistory));
        command.append(" ");
        command.append(path);
        command.append(" ");
        command.append(REVISION);
        command.append(" ");
        command.append(fromRevision);
        command.append(":");
        command.append(toRevision);
        return this.getRevisions(path, command.toString());
    }

    @Override
    public List<RevisionObject> revisions(String path, Date date, boolean stopOnCopy, boolean useMergeHistory) throws CommandException {
        StringBuffer command = new StringBuffer();
        command.append(this.getLogCommand(stopOnCopy, useMergeHistory));
        command.append(" ");
        command.append(path);
        command.append(" ");
        command.append(REVISION);
        command.append(" ");
        command.append(SvnUtility.getDateArguments(date, date));
        List<RevisionObject> revisions = this.getRevisions(path, command.toString());
        this.adjustLogs(revisions);
        return revisions;
    }

    @Override
    public List<RevisionObject> revisions(String path, Date fromDate, Date toDate, boolean stopOnCopy, boolean useMergeHistory) throws CommandException {
        StringBuffer command = new StringBuffer();
        command.append(this.getLogCommand(stopOnCopy, useMergeHistory));
        command.append(" ");
        command.append(path);
        command.append(" ");
        command.append(REVISION);
        command.append(" ");
        command.append(SvnUtility.getDateArguments(fromDate, toDate));
        List<RevisionObject> logs = this.getRevisions(path, command.toString());
        this.adjustLogs(logs);
        return logs;
    }

    @Override
    public List<ChangeObject> changes(RevisionObject revision) throws CommandException {
        String hpath = this.getProfile().getHttp();
        String ppath = this.getProfile().getPath().replace('\\', '/');
        String rpath = revision.getPath().replace('\\', '/');
        Long rev = revision.getRevision();
        StringBuffer command = new StringBuffer();
        command.append(this.getLogCommand(true, false));
        command.append(" ");
        command.append("-v");
        command.append(" ");
        command.append(hpath);
        command.append('/');
        command.append(rpath);
        command.append(" ");
        command.append(REVISION);
        command.append(" ");
        command.append(revision.getRevision());
        List<XmlNode> entries = this.getEntries(command.toString());
        ArrayList<ChangeObject> changes = new ArrayList<ChangeObject>(0);
        if (entries != null && entries.size() == 1) {
            changes.addAll(this.getChanges(entries.get(0)));
            this.getChanged(ppath, rev, changes);
        }
        return changes;
    }

    private String getLogCommand(boolean stopOnCopy, boolean useMergeHistory) {
        StringBuffer command = new StringBuffer();
        command.append(LOG);
        if (stopOnCopy) {
            command.append(" ");
            command.append(STOP_ON_COPY);
        }
        if (useMergeHistory) {
            command.append(" ");
            command.append(USE_MERGE_HISTORY);
        }
        return command.toString();
    }

    private void adjustLogs(List<RevisionObject> revisions) {
        if (!revisions.isEmpty()) {
            revisions.remove(0);
        }
    }

    private List<XmlNode> getEntries(String command) throws CommandException {
        try {
            Feedback feedback = SvnUtility.runSvnCommand(this.getProfile(), command);
            if (feedback.isError()) {
                throw new CommandException(this.getErrorMessage(feedback));
            }
            XmlDocument document = feedback.getInputAsXmlDocument();
            return document.getRoot().getChildren("logentry");
        }
        catch (XmlException exception) {
            throw new CommandException(exception);
        }
    }

    private List<RevisionObject> getRevisions(String path, String command) throws CommandException {
        ArrayList<RevisionObject> revisions = new ArrayList<RevisionObject>();
        List<XmlNode> entries = this.getEntries(command);
        for (XmlNode entry : entries) {
            revisions.add(this.getRevision(path, entry));
        }
        return revisions;
    }

    private RevisionObject getRevision(String path, XmlNode entry) throws CommandException {
        RevisionObject revision = new RevisionObject();
        revision.setPath(path.substring(this.getProfile().getHttp().length()));
        revision.setRevision(Long.valueOf(entry.getAttribute("revision")));
        revision.setAuthor(entry.getChild("author").getValue());
        revision.setTimestamp(SvnUtility.getSVNFormattedDate(entry.getChild("date").getValue()));
        revision.setMessage(entry.getChild("msg").getValue());
        return revision;
    }

    private List<ChangeObject> getChanges(XmlNode entry) throws CommandException {
        ArrayList<ChangeObject> changes = new ArrayList<ChangeObject>();
        List<XmlNode> nodes = entry.getChild("paths").getChildren("path");
        for (XmlNode node : nodes) {
            changes.add(this.getChange(node));
        }
        return changes;
    }

    private ChangeObject getChange(XmlNode node) throws CommandException {
        ChangeObject change = new ChangeObject();
        change.setKind(SvnUtility.getKind(node.getAttribute("kind")));
        change.setChange(SvnUtility.getChange(node.getAttribute("action")));
        change.setPath(node.getValue());
        if (!StringUtility.isEmpty(node.getAttribute("copyfrom-path")) && !StringUtility.isEmpty(node.getAttribute("copyfrom-rev"))) {
            change.setFromPath(node.getAttribute("copyfrom-path"));
            change.setFromRevision(Long.valueOf(node.getAttribute("copyfrom-rev")));
        }
        return change;
    }

    private void getChanged(String path, Long revision, List<ChangeObject> changes) throws CommandException {
        if (revision != null) {
            StringBuffer command = new StringBuffer();
            command.append(CHANGED);
            command.append(" ");
            command.append(REVISION);
            command.append(" ");
            command.append(revision);
            command.append(" ");
            command.append(path);
            Feedback feedback = SvnUtility.getSvnLookCommand(command.toString());
            if (feedback.getInput() != null && feedback.getInput().size() > 0) {
                for (String line : feedback.getInput()) {
                    String mod = line.substring(0, 2).trim();
                    String fil = line.substring(2).trim();
                    for (ChangeObject change : changes) {
                        this.setChanged(change, mod, fil);
                    }
                }
            }
        }
    }

    private void setChanged(ChangeObject change, String mod, String fil) {
        if (change.getPath().indexOf(fil) > -1) {
            if (mod.equals("U")) {
                change.setModifiedFile(true);
            } else if (mod.equals("_U")) {
                change.setModifiedProperty(true);
            } else if (mod.equals("UU")) {
                change.setModifiedFile(true);
                change.setModifiedProperty(true);
            }
        }
    }
}

