/*
 * Decompiled with CFR 0.152.
 */
package zen.scm.implementations.svn;

import java.util.ArrayList;
import java.util.List;
import zen.scm.CommandException;
import zen.scm.abstracts.AbstractLockCommand;
import zen.scm.implementations.svn.SvnUtility;
import zen.scm.objects.LockObject;
import zen.scm.objects.ProfileObject;
import zen.string.StringUtility;
import zen.system.Feedback;

public class SVNLockCommand
extends AbstractLockCommand {
    private static final String LSLOCKS = "lslocks";
    private static final String RMLOCKS = "rmlocks";

    public SVNLockCommand(ProfileObject profile) {
        super(profile);
    }

    @Override
    public List<LockObject> list(String path) throws CommandException {
        StringBuffer command = new StringBuffer(20);
        command.append(LSLOCKS);
        command.append(" ");
        command.append(path);
        Feedback feedback = SvnUtility.getSvnAdminCommand(command.toString());
        ArrayList<LockObject> locks = new ArrayList<LockObject>();
        if (feedback.getInput() != null && !feedback.getInput().isEmpty()) {
            LockObject lock = null;
            StringBuffer message = null;
            for (String line : feedback.getInput()) {
                int index = line.indexOf(":");
                if (line.indexOf("Path:") > -1) {
                    lock = new LockObject();
                    lock.setPath(line.substring(index + 1).trim());
                    continue;
                }
                if (line.indexOf("UUID Token:") > -1) {
                    lock.setUniqueId(line.substring(index + 1).trim());
                    continue;
                }
                if (line.indexOf("Owner:") > -1) {
                    lock.setOwner(line.substring(index + 1).trim());
                    continue;
                }
                if (line.indexOf("Created:") > -1) {
                    lock.setCreated(SvnUtility.getFormattedDate(line.substring(index + 1).trim()));
                    continue;
                }
                if (line.indexOf("Expires:") > -1) {
                    LOG.debug(this.getClass(), "ignoring the expires attribute for now");
                    continue;
                }
                if (StringUtility.isEmpty(line)) {
                    lock.setMessage(message.toString());
                    locks.add(lock);
                    LOG.debug(this.getClass(), "Path [" + lock.getPath() + "]  Owner [" + lock.getOwner() + "]");
                    continue;
                }
                if (line.indexOf("Comment") > -1) {
                    message = new StringBuffer();
                    continue;
                }
                if (message == null) continue;
                message.append(line);
            }
        }
        return locks;
    }

    @Override
    public List<String> remove(String path, List<LockObject> locks) throws CommandException {
        ArrayList<String> messages = new ArrayList<String>();
        for (LockObject lock : locks) {
            messages.addAll(this.remove(path, lock.getPath()));
        }
        return messages;
    }

    @Override
    public List<String> remove(String path, String file) throws CommandException {
        StringBuffer command = new StringBuffer(20);
        command.append(RMLOCKS);
        command.append(" ");
        command.append(path);
        command.append(" ");
        command.append(file);
        Feedback feedback = SvnUtility.getSvnAdminCommand(command.toString());
        if (feedback.isError()) {
            throw new CommandException(this.getErrorMessage(feedback));
        }
        return feedback.getInput();
    }
}

