/*
 * Decompiled with CFR 0.152.
 */
package zen.scm.implementations.svn;

import java.util.ArrayList;
import java.util.List;
import zen.scm.CommandException;
import zen.scm.abstracts.AbstractListCommand;
import zen.scm.implementations.svn.SvnUtility;
import zen.scm.objects.NodeObject;
import zen.scm.objects.ProfileObject;
import zen.system.Feedback;
import zen.xml.XmlDocument;
import zen.xml.XmlException;
import zen.xml.XmlNode;

public class SVNListCommand
extends AbstractListCommand {
    private static final String LIST_COMMAND = "list --xml";
    private static final String REVISION = "-r";
    private static final String RECURSIVE = "-R";

    public SVNListCommand(ProfileObject profile) {
        super(profile);
    }

    @Override
    public List<NodeObject> list(String path, boolean recursive) throws CommandException {
        StringBuffer command = new StringBuffer(20);
        command.append(this.getCommand(recursive));
        command.append(" ");
        command.append(path);
        Feedback feedback = SvnUtility.runSvnCommand(this.getProfile(), command.toString());
        if (feedback.isError()) {
            throw new CommandException(this.getErrorMessage(feedback));
        }
        return this.getNodes(feedback);
    }

    @Override
    public List<NodeObject> list(String path, Long revision, boolean recursive) throws CommandException {
        StringBuffer command = new StringBuffer(20);
        command.append(this.getCommand(recursive));
        command.append(" ");
        command.append(REVISION);
        command.append(" ");
        command.append(revision);
        command.append(" ");
        command.append(path);
        Feedback feedback = SvnUtility.runSvnCommand(this.getProfile(), command.toString());
        if (feedback.isError()) {
            throw new CommandException(this.getErrorMessage(feedback));
        }
        return this.getNodes(feedback);
    }

    private String getCommand(boolean recursive) {
        StringBuffer command = new StringBuffer(20);
        command.append(LIST_COMMAND);
        if (recursive) {
            command.append(" ");
            command.append(RECURSIVE);
        }
        return command.toString();
    }

    private List<NodeObject> getNodes(Feedback feedback) throws CommandException {
        try {
            ArrayList<NodeObject> nodes = new ArrayList<NodeObject>();
            XmlDocument document = feedback.getInputAsXmlDocument();
            XmlNode list = document.getNode("list");
            String path = list.getAttribute("path");
            List<XmlNode> entries = list.getChildren("entry");
            for (XmlNode entry : entries) {
                nodes.add(this.getNodeObject(entry, path));
            }
            return nodes;
        }
        catch (XmlException exception) {
            throw new CommandException(exception);
        }
    }

    private NodeObject getNodeObject(XmlNode entry, String path) {
        NodeObject node = new NodeObject();
        String name = entry.getChild("name").getValue();
        node.setKind(SvnUtility.getKind(entry.getAttribute("kind")));
        node.setPath(String.valueOf(path) + "/" + name);
        return node;
    }
}

