/*
 * Decompiled with CFR 0.152.
 */
package zen.scm.implementations.svn;

import zen.scm.CommandException;
import zen.scm.abstracts.AbstractInfoCommand;
import zen.scm.implementations.svn.SvnUtility;
import zen.scm.objects.InfoObject;
import zen.scm.objects.ProfileObject;
import zen.system.Feedback;
import zen.xml.XmlDocument;
import zen.xml.XmlException;
import zen.xml.XmlNode;

public class SVNInfoCommand
extends AbstractInfoCommand {
    private static final String INFO = "info --xml";
    private static final String REVISION = "-r";

    public SVNInfoCommand(ProfileObject profile) {
        super(profile);
    }

    @Override
    public InfoObject info(String urlPath, Long revision) throws CommandException {
        StringBuffer command = new StringBuffer();
        command.append(INFO);
        command.append(" ");
        command.append(REVISION);
        command.append(" ");
        command.append(revision.toString());
        command.append(" ");
        command.append(urlPath);
        Feedback feedback = SvnUtility.runSvnCommand(this.getProfile(), command.toString());
        if (feedback.isError()) {
            throw new CommandException(this.getErrorMessage(feedback));
        }
        return this.getInfoObject(feedback);
    }

    @Override
    public InfoObject info(String urlPath) throws CommandException {
        StringBuffer command = new StringBuffer();
        command.append(INFO);
        command.append(" ");
        command.append(urlPath);
        Feedback feedback = SvnUtility.runSvnCommand(this.getProfile(), command.toString());
        if (feedback.isError()) {
            throw new CommandException(this.getErrorMessage(feedback));
        }
        return this.getInfoObject(feedback);
    }

    private InfoObject getInfoObject(Feedback feedback) throws CommandException {
        try {
            XmlDocument document = feedback.getInputAsXmlDocument();
            XmlNode root = document.getRoot();
            XmlNode entry = root.getChild("entry");
            XmlNode repository = entry.getChild("repository");
            XmlNode commit = entry.getChild("commit");
            InfoObject info = new InfoObject();
            info.setPath(entry.getChild("url").getValue());
            info.setRepository(repository.getChild("root").getValue());
            info.setRevision(Long.valueOf(commit.getAttribute("revision")));
            info.setAuthor(commit.getChild("author").getValue());
            info.setTimestamp(SvnUtility.getSVNFormattedDate(commit.getChild("date").getValue()));
            return info;
        }
        catch (XmlException exception) {
            throw new CommandException(exception);
        }
    }
}

