/*
 * Decompiled with CFR 0.152.
 */
package zen.scm.implementations.svn;

import java.util.ArrayList;
import java.util.List;
import zen.scm.CommandException;
import zen.scm.abstracts.AbstractDiffCommand;
import zen.scm.enums.Change;
import zen.scm.implementations.svn.SvnUtility;
import zen.scm.objects.ChangeObject;
import zen.scm.objects.ProfileObject;
import zen.system.Feedback;
import zen.xml.XmlDocument;
import zen.xml.XmlException;
import zen.xml.XmlNode;

public class SVNDiffCommand
extends AbstractDiffCommand {
    private static final String DIFF_COMMAND = "diff";
    private static final String XML = "--xml";
    private static final String SUMMARY = "--summarize";
    private static final String REVISION = "-r";
    private static final String AT_SYMBOL = "@";

    public SVNDiffCommand(ProfileObject profile) {
        super(profile);
    }

    @Override
    public List<String> diff(String path1, Long revision1, Long revision2) throws CommandException {
        StringBuffer command = new StringBuffer(20);
        command.append(this.getCommand(false));
        command.append(" ");
        command.append(REVISION);
        command.append(" ");
        command.append(revision1);
        command.append(":");
        command.append(revision2);
        command.append(" ");
        command.append(path1);
        Feedback feedback = SvnUtility.runSvnCommand(this.getProfile(), command.toString());
        return this.process(feedback);
    }

    @Override
    public List<String> diff(String path1, Long revision1, String path2, Long revision2) throws CommandException {
        StringBuffer command = new StringBuffer(20);
        command.append(this.getCommand(false));
        command.append(" ");
        command.append(path1);
        command.append(AT_SYMBOL);
        command.append(revision1);
        command.append(" ");
        command.append(path2);
        command.append(AT_SYMBOL);
        command.append(revision2);
        Feedback feedback = SvnUtility.runSvnCommand(this.getProfile(), command.toString());
        return this.process(feedback);
    }

    @Override
    public List<String> diff(String path1, String path2) throws CommandException {
        StringBuffer command = new StringBuffer(20);
        command.append(this.getCommand(false));
        command.append(" ");
        command.append(path1);
        command.append(AT_SYMBOL);
        command.append("HEAD");
        command.append(" ");
        command.append(path2);
        command.append(AT_SYMBOL);
        command.append("HEAD");
        Feedback feedback = SvnUtility.runSvnCommand(this.getProfile(), command.toString());
        return this.process(feedback);
    }

    @Override
    public List<ChangeObject> summarize(String path1, Long revision1, Long revision2) throws CommandException {
        StringBuffer command = new StringBuffer(20);
        command.append(this.getCommand(true));
        command.append(" ");
        command.append(REVISION);
        command.append(" ");
        command.append(revision1);
        command.append(":");
        command.append(revision2);
        command.append(" ");
        command.append(path1);
        Feedback feedback = SvnUtility.runSvnCommand(this.getProfile(), command.toString());
        return this.getSummary(feedback);
    }

    @Override
    public List<ChangeObject> summarize(String path1, Long revision1, String path2, Long revision2) throws CommandException {
        StringBuffer command = new StringBuffer(20);
        command.append(this.getCommand(true));
        command.append(" ");
        command.append(path1);
        command.append(AT_SYMBOL);
        command.append(revision1);
        command.append(" ");
        command.append(path2);
        command.append(AT_SYMBOL);
        command.append(revision2);
        Feedback feedback = SvnUtility.runSvnCommand(this.getProfile(), command.toString());
        return this.getSummary(feedback);
    }

    @Override
    public List<ChangeObject> summarize(String path1, String path2) throws CommandException {
        StringBuffer command = new StringBuffer(20);
        command.append(this.getCommand(true));
        command.append(" ");
        command.append(path1);
        command.append(AT_SYMBOL);
        command.append("HEAD");
        command.append(" ");
        command.append(path2);
        command.append(AT_SYMBOL);
        command.append("HEAD");
        Feedback feedback = SvnUtility.runSvnCommand(this.getProfile(), command.toString());
        return this.getSummary(feedback);
    }

    private String getCommand(boolean summarize) {
        String command = null;
        command = summarize ? "diff --xml --summarize" : DIFF_COMMAND;
        return command;
    }

    private List<String> process(Feedback feedback) throws CommandException {
        if (feedback.isError()) {
            throw new CommandException(this.getErrorMessage(feedback));
        }
        return feedback.getInput();
    }

    private List<ChangeObject> getSummary(Feedback feedback) throws CommandException {
        try {
            ArrayList<ChangeObject> changes = new ArrayList<ChangeObject>();
            if (feedback.isError()) {
                throw new CommandException(this.getErrorMessage(feedback));
            }
            XmlDocument document = feedback.getInputAsXmlDocument();
            List<XmlNode> paths = document.getNode("paths").getChildren("path");
            for (XmlNode path : paths) {
                changes.add(this.getChange(path));
            }
            return changes;
        }
        catch (XmlException exception) {
            throw new CommandException(exception);
        }
    }

    private ChangeObject getChange(XmlNode path) {
        ChangeObject change = new ChangeObject();
        change.setPath(path.getValue());
        this.setChange(change, path);
        change.setKind(SvnUtility.getKind(path.getAttribute("kind")));
        return change;
    }

    private void setChange(ChangeObject change, XmlNode path) {
        String item = path.getAttribute("item");
        if ("added".equals(item)) {
            change.setChange(Change.ADDED);
            change.setModifiedFile(true);
        } else if ("deleted".equals(item)) {
            change.setChange(Change.DELETED);
            change.setModifiedFile(true);
        } else if ("modified".equals(item)) {
            change.setChange(Change.MODIFIED);
            change.setModifiedFile(true);
        } else if ("none".equals(item)) {
            change.setModifiedFile(false);
        }
        String props = path.getAttribute("props");
        if ("added".equals(props)) {
            change.setChange(Change.ADDED);
            change.setModifiedProperty(true);
        } else if ("deleted".equals(props)) {
            change.setChange(Change.DELETED);
            change.setModifiedProperty(true);
        } else if ("modified".equals(props)) {
            change.setChange(Change.MODIFIED);
            change.setModifiedProperty(true);
        } else if ("none".equals(props)) {
            change.setModifiedProperty(false);
        }
    }
}

