/*
 * Decompiled with CFR 0.152.
 */
package zen.scm.implementations.svn;

import zen.scm.CommandException;
import zen.scm.abstracts.AbstractCheckoutCommand;
import zen.scm.implementations.svn.SvnUtility;
import zen.scm.objects.ProfileObject;
import zen.system.Feedback;

public class SVNCheckoutCommand
extends AbstractCheckoutCommand {
    private static final String CHECKOUT = "co";
    private static final String REVISION = "-r";

    public SVNCheckoutCommand(ProfileObject profile) {
        super(profile);
    }

    @Override
    public Feedback checkout(String urlPath, String localPath, Long revision) throws CommandException {
        StringBuffer command = new StringBuffer();
        command.append(CHECKOUT);
        command.append(" ");
        command.append(REVISION);
        command.append(" ");
        command.append(revision.toString());
        command.append(" ");
        command.append(urlPath);
        command.append(" ");
        command.append(localPath);
        return SvnUtility.runSvnCommand(this.getProfile(), command.toString());
    }

    @Override
    public Feedback checkout(String urlPath, String localPath) throws CommandException {
        StringBuffer command = new StringBuffer();
        command.append(CHECKOUT);
        command.append(" ");
        command.append(urlPath);
        command.append(" ");
        command.append(localPath);
        return SvnUtility.runSvnCommand(this.getProfile(), command.toString());
    }
}

