/*
 * Decompiled with CFR 0.152.
 */
package zen.scm.implementations.svn;

import java.util.List;
import zen.scm.CommandException;
import zen.scm.abstracts.AbstractCatCommand;
import zen.scm.implementations.svn.SvnUtility;
import zen.scm.objects.ProfileObject;
import zen.system.Feedback;

public class SVNCatCommand
extends AbstractCatCommand {
    private static final String CAT_COMMAND = "cat";
    private static final String REVISION = "-r";

    public SVNCatCommand(ProfileObject profile) {
        super(profile);
    }

    @Override
    public List<String> cat(String path) throws CommandException {
        StringBuffer command = new StringBuffer(20);
        command.append(CAT_COMMAND);
        command.append(" ");
        command.append(REVISION);
        command.append(" ");
        command.append("HEAD");
        command.append(" ");
        command.append(path);
        Feedback feedback = SvnUtility.runSvnCommand(this.getProfile(), command.toString());
        if (feedback.isError()) {
            throw new CommandException(this.getErrorMessage(feedback));
        }
        return feedback.getInput();
    }

    @Override
    public List<String> cat(String path, Long revision) throws CommandException {
        StringBuffer command = new StringBuffer(20);
        command.append(CAT_COMMAND);
        command.append(" ");
        command.append(REVISION);
        command.append(" ");
        command.append(revision);
        command.append(" ");
        command.append(path);
        Feedback feedback = SvnUtility.runSvnCommand(this.getProfile(), command.toString());
        if (feedback.isError()) {
            throw new CommandException(this.getErrorMessage(feedback));
        }
        return feedback.getInput();
    }
}

