/*
 * Decompiled with CFR 0.152.
 */
package zen.scm;

import java.util.HashMap;
import java.util.Map;
import zen.logging.interfaces.ILogging;
import zen.scm.CommandException;
import zen.scm.abstracts.AbstractCatCommand;
import zen.scm.abstracts.AbstractCheckoutCommand;
import zen.scm.abstracts.AbstractCommandFactory;
import zen.scm.abstracts.AbstractDiffCommand;
import zen.scm.abstracts.AbstractInfoCommand;
import zen.scm.abstracts.AbstractListCommand;
import zen.scm.abstracts.AbstractLockCommand;
import zen.scm.abstracts.AbstractLogCommand;
import zen.scm.enums.Scm;
import zen.scm.implementations.svn.SVNCommandFactory;
import zen.scm.objects.ProfileObject;

public final class Commands
implements ILogging {
    private static final Map<Scm, AbstractCommandFactory> FACTORIES = new HashMap<Scm, AbstractCommandFactory>();

    static {
        FACTORIES.put(Scm.SVN, new SVNCommandFactory());
    }

    private Commands() {
    }

    public static AbstractCatCommand getContentCommand(ProfileObject profile) throws CommandException {
        return Commands.getFactory(profile).getContentCommand(profile);
    }

    public static AbstractDiffCommand getDifferenceCommand(ProfileObject profile) throws CommandException {
        return Commands.getFactory(profile).getDifferenceCommand(profile);
    }

    public static AbstractListCommand getListCommand(ProfileObject profile) throws CommandException {
        return Commands.getFactory(profile).getListCommand(profile);
    }

    public static AbstractLockCommand getLockCommand(ProfileObject profile) throws CommandException {
        return Commands.getFactory(profile).getLockCommand(profile);
    }

    public static AbstractLogCommand getLogCommand(ProfileObject profile) throws CommandException {
        return Commands.getFactory(profile).getLogCommand(profile);
    }

    public static AbstractInfoCommand getInfoCommand(ProfileObject profile) throws CommandException {
        return Commands.getFactory(profile).getInfoCommand(profile);
    }

    public static AbstractCheckoutCommand getCheckoutCommand(ProfileObject profile) throws CommandException {
        return Commands.getFactory(profile).getCheckoutCommand(profile);
    }

    public static AbstractCommandFactory getFactory(ProfileObject profile) throws CommandException {
        AbstractCommandFactory factory = Commands.getFactory(profile.getScm());
        if (factory != null) {
            return factory;
        }
        throw new CommandException("No factory found for SCM: " + profile.getScm().toString());
    }

    private static AbstractCommandFactory getFactory(Scm scm) {
        AbstractCommandFactory factory = null;
        if (FACTORIES.containsKey((Object)scm)) {
            factory = FACTORIES.get((Object)scm);
        }
        return factory;
    }
}

