/*
 * Decompiled with CFR 0.152.
 */
package zen.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.draw.DrawInterface;
import com.itextpdf.text.pdf.draw.VerticalPositionMark;
import java.math.BigDecimal;
import java.text.NumberFormat;
import zen.logging.interfaces.ILogging;

public class PDFTable
implements ILogging {
    private static final Font NORMAL_FONT = new Font(Font.FontFamily.TIMES_ROMAN, 12.0f, 0, BaseColor.BLACK);
    private static final Font BOLD_FONT = new Font(Font.FontFamily.TIMES_ROMAN, 12.0f, 1, BaseColor.BLACK);
    private final transient PdfPTable table;

    protected PDFTable(PdfPTable pdfPTtable, float width) {
        this.table = pdfPTtable;
        this.table.setTotalWidth(width);
    }

    protected PdfPTable getTable() {
        return this.table;
    }

    private void setDefaulPadding(PdfPCell cell) {
        cell.setPaddingTop(1.0f);
        cell.setPaddingLeft(5.0f);
        cell.setPaddingBottom(1.0f);
        cell.setPaddingRight(5.0f);
    }

    public void addCell(String text, Font font) {
        PdfPCell cell = new PdfPCell();
        this.setDefaulPadding(cell);
        cell.setNoWrap(true);
        cell.setBorder(0);
        cell.addElement((Element)new Chunk(text, font));
        this.table.addCell(cell);
    }

    public void addCell(String text, Font font, int border) {
        PdfPCell cell = new PdfPCell();
        this.setDefaulPadding(cell);
        cell.setNoWrap(true);
        cell.setBorder(border);
        cell.addElement((Element)new Chunk(text, font));
        this.table.addCell(cell);
    }

    public void addCell(String text, Font font, int colSpan, int border) {
        PdfPCell cell = new PdfPCell();
        cell.setColspan(colSpan);
        cell.setNoWrap(true);
        this.setDefaulPadding(cell);
        cell.setBorder(border);
        cell.addElement((Element)new Chunk(text, font));
        this.table.addCell(cell);
    }

    public void addCell(String text, Font font, float padding, int border) {
        PdfPCell cell = new PdfPCell();
        cell.setNoWrap(true);
        cell.setPadding(padding);
        cell.setBorder(border);
        cell.addElement((Element)new Chunk(text, font));
        this.table.addCell(cell);
    }

    public void addCell(String text, Font font, int colSpan, float padding, int border) {
        PdfPCell cell = new PdfPCell();
        cell.setColspan(colSpan);
        cell.setNoWrap(true);
        cell.setPadding(padding);
        cell.setBorder(border);
        cell.addElement((Element)new Chunk(text, font));
        this.table.addCell(cell);
    }

    public void addCell(String text, Font font, BaseColor backgroundColor) {
        PdfPCell cell = new PdfPCell();
        this.setDefaulPadding(cell);
        cell.setNoWrap(true);
        cell.setBackgroundColor(backgroundColor);
        cell.setBorder(0);
        cell.addElement((Element)new Chunk(text, font));
        this.table.addCell(cell);
    }

    public void addCell(String text, Font font, BaseColor backgroundColor, int border) {
        PdfPCell cell = new PdfPCell();
        this.setDefaulPadding(cell);
        cell.setNoWrap(true);
        cell.setBackgroundColor(backgroundColor);
        cell.setBorder(border);
        cell.addElement((Element)new Chunk(text, font));
        this.table.addCell(cell);
    }

    public void addCell(String text, Font font, BaseColor backgroundColor, int colSpan, int border) {
        PdfPCell cell = new PdfPCell();
        this.setDefaulPadding(cell);
        cell.setNoWrap(true);
        cell.setColspan(colSpan);
        cell.setBackgroundColor(backgroundColor);
        cell.setBorder(border);
        cell.addElement((Element)new Chunk(text, font));
        this.table.addCell(cell);
    }

    public void addCell(String text, Font font, BaseColor backgroundColor, float padding, int border) {
        PdfPCell cell = new PdfPCell();
        cell.setBackgroundColor(backgroundColor);
        cell.setNoWrap(true);
        cell.setPadding(padding);
        cell.setBorder(border);
        cell.addElement((Element)new Chunk(text, font));
        this.table.addCell(cell);
    }

    public void addCell(String text, Font font, BaseColor backgroundColor, int colSpan, float padding, int border) {
        PdfPCell cell = new PdfPCell();
        cell.setBackgroundColor(backgroundColor);
        cell.setNoWrap(true);
        cell.setColspan(colSpan);
        cell.setPadding(padding);
        cell.setBorder(border);
        cell.addElement((Element)new Chunk(text, font));
        this.table.addCell(cell);
    }

    public void addFormatedCell(String name, String value, int tab) {
        PdfPCell cell = new PdfPCell();
        this.setDefaulPadding(cell);
        cell.setNoWrap(true);
        cell.setBorder(0);
        this.table.addCell(cell);
        Phrase phrase = new Phrase();
        phrase.add((Element)new Chunk(name, NORMAL_FONT));
        phrase.add((Element)new Chunk((DrawInterface)new VerticalPositionMark(), (float)tab));
        phrase.add((Element)new Chunk(value, BOLD_FONT));
        cell.addElement((Element)phrase);
    }

    public void addFormatedCell(String name, Font nameFont, String value, Font valueFont, int tab) {
        PdfPCell cell = new PdfPCell();
        this.setDefaulPadding(cell);
        cell.setNoWrap(true);
        cell.setBorder(0);
        this.table.addCell(cell);
        Phrase phrase = new Phrase();
        phrase.add((Element)new Chunk(name, nameFont));
        phrase.add((Element)new Chunk((DrawInterface)new VerticalPositionMark(), (float)tab));
        phrase.add((Element)new Chunk(value, valueFont));
        cell.addElement((Element)phrase);
    }

    public void addFormatedCell(String name, Font nameFont, String value, Font valueFont, int tab, int colSpan) {
        PdfPCell cell = new PdfPCell();
        cell.setColspan(colSpan);
        this.setDefaulPadding(cell);
        cell.setNoWrap(true);
        cell.setBorder(0);
        this.table.addCell(cell);
        Phrase phrase = new Phrase();
        phrase.add((Element)new Chunk(name, nameFont));
        phrase.add((Element)new Chunk((DrawInterface)new VerticalPositionMark(), (float)tab));
        phrase.add((Element)new Chunk(value, valueFont));
        cell.addElement((Element)phrase);
    }

    public void addFormatedCell(String name, Font nameFont, String value, Font valueFont, int tab, float padding) {
        PdfPCell cell = new PdfPCell();
        cell.setNoWrap(true);
        cell.setPadding(padding);
        cell.setBorder(0);
        this.table.addCell(cell);
        Phrase phrase = new Phrase();
        phrase.add((Element)new Chunk(name, nameFont));
        phrase.add((Element)new Chunk((DrawInterface)new VerticalPositionMark(), (float)tab));
        phrase.add((Element)new Chunk(value, valueFont));
        cell.addElement((Element)phrase);
    }

    public void addFormatedCell(String name, Font nameFont, String value, Font valueFont, int tab, float padding, int border) {
        PdfPCell cell = new PdfPCell();
        cell.setNoWrap(true);
        cell.setPadding(padding);
        cell.setBorder(border);
        this.table.addCell(cell);
        Phrase phrase = new Phrase();
        phrase.add((Element)new Chunk(name, nameFont));
        phrase.add((Element)new Chunk((DrawInterface)new VerticalPositionMark(), (float)tab));
        phrase.add((Element)new Chunk(value, valueFont));
        cell.addElement((Element)phrase);
    }

    public void addFormatedCell(String name, Font nameFont, String value, Font valueFont, int tab, int colSpan, float padding, int border) {
        PdfPCell cell = new PdfPCell();
        cell.setNoWrap(true);
        cell.setColspan(colSpan);
        cell.setPadding(padding);
        cell.setBorder(border);
        this.table.addCell(cell);
        Phrase phrase = new Phrase();
        phrase.add((Element)new Chunk(name, nameFont));
        phrase.add((Element)new Chunk((DrawInterface)new VerticalPositionMark(), (float)tab));
        phrase.add((Element)new Chunk(value, valueFont));
        cell.addElement((Element)phrase);
    }

    public void addFormatedCell(String name, BigDecimal value, int tab) {
        PdfPCell cell = new PdfPCell();
        this.setDefaulPadding(cell);
        cell.setNoWrap(true);
        cell.setBorder(0);
        this.table.addCell(cell);
        Phrase phrase = new Phrase();
        phrase.add((Element)new Chunk(name, NORMAL_FONT));
        phrase.add((Element)new Chunk((DrawInterface)new VerticalPositionMark(), (float)tab));
        phrase.add((Element)new Chunk(NumberFormat.getInstance().format(value), BOLD_FONT));
        cell.addElement((Element)phrase);
    }

    public void addFormatedCell(String name, Font nameFont, BigDecimal value, Font valueFont, int tab) {
        PdfPCell cell = new PdfPCell();
        this.setDefaulPadding(cell);
        cell.setNoWrap(true);
        cell.setBorder(0);
        this.table.addCell(cell);
        Phrase phrase = new Phrase();
        phrase.add((Element)new Chunk(name, nameFont));
        phrase.add((Element)new Chunk((DrawInterface)new VerticalPositionMark(), (float)tab));
        phrase.add((Element)new Chunk(NumberFormat.getInstance().format(value), valueFont));
        cell.addElement((Element)phrase);
    }

    public void addFormatedCell(String name, Font nameFont, BigDecimal value, Font valueFont, int tab, int colSpan) {
        PdfPCell cell = new PdfPCell();
        cell.setColspan(colSpan);
        this.setDefaulPadding(cell);
        cell.setNoWrap(true);
        cell.setBorder(0);
        this.table.addCell(cell);
        Phrase phrase = new Phrase();
        phrase.add((Element)new Chunk(name, nameFont));
        phrase.add((Element)new Chunk((DrawInterface)new VerticalPositionMark(), (float)tab));
        phrase.add((Element)new Chunk(NumberFormat.getInstance().format(value), valueFont));
        cell.addElement((Element)phrase);
    }

    public void addFormatedCell(String name, Font nameFont, BigDecimal value, Font valueFont, int tab, float padding) {
        PdfPCell cell = new PdfPCell();
        cell.setNoWrap(true);
        cell.setPadding(padding);
        cell.setBorder(0);
        this.table.addCell(cell);
        Phrase phrase = new Phrase();
        phrase.add((Element)new Chunk(name, nameFont));
        phrase.add((Element)new Chunk((DrawInterface)new VerticalPositionMark(), (float)tab));
        phrase.add((Element)new Chunk(NumberFormat.getInstance().format(value), valueFont));
        cell.addElement((Element)phrase);
    }

    public void addFormatedCell(String name, Font nameFont, BigDecimal value, Font valueFont, int tab, float padding, int border) {
        PdfPCell cell = new PdfPCell();
        cell.setNoWrap(true);
        cell.setPadding(padding);
        cell.setBorder(border);
        this.table.addCell(cell);
        Phrase phrase = new Phrase();
        phrase.add((Element)new Chunk(name, nameFont));
        phrase.add((Element)new Chunk((DrawInterface)new VerticalPositionMark(), (float)tab));
        phrase.add((Element)new Chunk(NumberFormat.getInstance().format(value), valueFont));
        cell.addElement((Element)phrase);
    }

    public void addFormatedCell(String name, Font nameFont, BigDecimal value, Font valueFont, int tab, int colSpan, float padding, int border) {
        PdfPCell cell = new PdfPCell();
        cell.setColspan(colSpan);
        cell.setNoWrap(true);
        cell.setPadding(padding);
        cell.setBorder(border);
        this.table.addCell(cell);
        Phrase phrase = new Phrase();
        phrase.add((Element)new Chunk(name, nameFont));
        phrase.add((Element)new Chunk((DrawInterface)new VerticalPositionMark(), (float)tab));
        phrase.add((Element)new Chunk(NumberFormat.getInstance().format(value), valueFont));
        cell.addElement((Element)phrase);
    }
}

