/*
 * Decompiled with CFR 0.152.
 */
package zen.pdf;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.DefaultFontMapper;
import com.itextpdf.text.pdf.FontMapper;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDocument;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.draw.LineSeparator;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.net.URL;
import org.jfree.chart.JFreeChart;
import zen.classpath.ClasspathUtility;
import zen.logging.interfaces.ILogging;
import zen.pdf.PDFAlign;
import zen.pdf.PDFFooter;
import zen.pdf.PDFHeader;
import zen.pdf.PDFTable;

public class PDFPage
implements ILogging {
    private final transient PdfWriter writer;
    private final transient Document document;
    private final transient PdfDocument pdfDocument;
    private final transient PdfContentByte content;

    protected PDFPage(PdfWriter writer, Document document) {
        this.writer = writer;
        this.document = document;
        this.content = writer.getDirectContentUnder();
        this.pdfDocument = this.content.getPdfDocument();
    }

    public float getWidth() {
        return this.content.getPdfDocument().getPageSize().getWidth();
    }

    public float getHeight() {
        return this.content.getPdfDocument().getPageSize().getHeight();
    }

    public PDFHeader getPDFHeader() {
        return new PDFHeader(this.writer);
    }

    public PDFFooter getPDFFooter() {
        return new PDFFooter(this.writer);
    }

    public void writeContent(String text, String fontName, BaseColor fontColor, float fontSize, PDFAlign alignment, int xPosition, int yPosition) throws DocumentException, IOException {
        this.content.beginText();
        this.content.setColorFill(fontColor);
        this.content.setFontAndSize(BaseFont.createFont((String)fontName, (String)"UTF-8", (boolean)true), fontSize);
        this.content.showTextAligned(alignment.value(), text, (float)xPosition, (float)yPosition, 0.0f);
        this.content.endText();
    }

    public void writeContent(String text, Font font, PDFAlign alignment, int xPosition, int yPosition) throws DocumentException, IOException {
        this.content.beginText();
        this.content.setColorFill(font.getColor());
        this.content.setFontAndSize(BaseFont.createFont((String)font.getFamilyname(), (String)"UTF-8", (boolean)true), font.getSize());
        this.content.showTextAligned(alignment.value(), text, (float)xPosition, (float)yPosition, 0.0f);
        this.content.endText();
    }

    public void writeText(String text) throws DocumentException {
        this.document.add((Element)new Chunk(text));
    }

    public void writeText(String text, Font font) throws DocumentException {
        this.document.add((Element)new Chunk(text, font));
    }

    public void writeTextLine(String text) throws DocumentException {
        this.document.add((Element)new Chunk(text));
        this.document.add((Element)Chunk.NEWLINE);
    }

    public void writeTextLine(String text, Font font) throws DocumentException {
        this.document.add((Element)new Chunk(text, font));
        this.document.add((Element)Chunk.NEWLINE);
    }

    public void writeLineSeparator() throws DocumentException {
        this.document.add((Element)new LineSeparator());
        this.document.add((Element)Chunk.NEWLINE);
    }

    public void writeLineSeparator(BaseColor color) throws DocumentException {
        this.document.add((Element)new LineSeparator(1.0f, 100.0f, color, 4, -2.0f));
        this.document.add((Element)Chunk.NEWLINE);
    }

    public void writeLineSeparator(float lineWidth, float percentage, BaseColor color, int alignment, float offset) throws DocumentException {
        this.document.add((Element)new LineSeparator(lineWidth, percentage, color, alignment, offset));
        this.document.add((Element)Chunk.NEWLINE);
    }

    public PDFTable newTable(int numOfColumns, float width) {
        return new PDFTable(new PdfPTable(numOfColumns), width);
    }

    public void writeTable(PDFTable table) {
        table.getTable().writeSelectedRows(0, table.getTable().size(), this.document.leftMargin(), this.pdfDocument.getVerticalPosition(true), this.writer.getDirectContent());
    }

    public void writeImage(String imagePath, float scalePercent, int xPosition, int yPosition, PDFAlign alignment) throws IOException, BadElementException, DocumentException {
        Image image = Image.getInstance((URL)ClasspathUtility.getUrlPath(imagePath));
        image.scalePercent(scalePercent);
        image.setAbsolutePosition((float)xPosition, (float)yPosition);
        image.setAlignment(alignment.value());
        this.content.addImage(image);
    }

    public void writeImage(String imagePath, float scalePercentX, float scalePercentY, int xPosition, int yPosition, PDFAlign alignment) throws IOException, BadElementException, DocumentException {
        Image image = Image.getInstance((URL)ClasspathUtility.getUrlPath(imagePath));
        image.scalePercent(scalePercentX, scalePercentY);
        image.setAbsolutePosition((float)xPosition, (float)yPosition);
        image.setAlignment(alignment.value());
        this.content.addImage(image);
    }

    public void writeChart(JFreeChart chart, float width, float height) throws DocumentException {
        PdfContentByte canvas = this.writer.getDirectContent();
        PdfTemplate template = canvas.createTemplate(width, height);
        Graphics2D graphics = template.createGraphics(width, height, (FontMapper)new DefaultFontMapper());
        Rectangle2D.Double rectangle = new Rectangle2D.Double(0.0, 0.0, width, height);
        chart.draw(graphics, (Rectangle2D)rectangle);
        graphics.dispose();
        Image image = Image.getInstance((PdfTemplate)template);
        image.setAlignment(1);
        this.document.add((Element)image);
        this.document.add((Element)Chunk.NEWLINE);
    }

    public void writeChart(JFreeChart chart, float width, float height, int alignment) throws DocumentException {
        PdfContentByte canvas = this.writer.getDirectContent();
        PdfTemplate template = canvas.createTemplate(width, height);
        Graphics2D graphics = template.createGraphics(width, height, (FontMapper)new DefaultFontMapper());
        Rectangle2D.Double rectangle = new Rectangle2D.Double(0.0, 0.0, width, height);
        chart.draw(graphics, (Rectangle2D)rectangle);
        graphics.dispose();
        Image image = Image.getInstance((PdfTemplate)template);
        image.setAlignment(alignment);
        this.document.add((Element)image);
        this.document.add((Element)Chunk.NEWLINE);
    }
}

