/*
 * Decompiled with CFR 0.152.
 */
package zen.pdf;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;
import java.net.URL;
import zen.classpath.ClasspathUtility;
import zen.pdf.PDFAlign;

public class PDFHeader {
    private static final String ENCODING = "UTF-8";
    private final transient PdfContentByte content;

    protected PDFHeader(PdfWriter writer) {
        this.content = writer.getDirectContentUnder();
    }

    public float getWidth() {
        return this.content.getPdfDocument().getPageSize().getWidth();
    }

    public float getHeight() {
        return this.content.getPdfDocument().getPageSize().getHeight();
    }

    public void addText(String text, int xPosition, int offsetFromTop, PDFAlign alignment, String fontType, BaseColor fontColor, float fontSize) throws IOException, DocumentException {
        int yPosition = (int)this.getHeight() - offsetFromTop;
        this.content.beginText();
        this.content.setColorFill(fontColor);
        this.content.setFontAndSize(BaseFont.createFont((String)fontType, (String)ENCODING, (boolean)true), fontSize);
        this.content.showTextAligned(alignment.value(), text, (float)xPosition, (float)yPosition, 0.0f);
        this.content.endText();
    }

    public void addImage(String imagePath, float scalePercent, int xPosition, int offsetFromTop, PDFAlign alignment) throws IOException, BadElementException, DocumentException {
        int yPosition = (int)this.getHeight() - offsetFromTop;
        Image image = Image.getInstance((URL)ClasspathUtility.getUrlPath(imagePath));
        image.scalePercent(scalePercent);
        image.setAbsolutePosition((float)xPosition, (float)yPosition);
        image.setAlignment(alignment.value());
        this.content.addImage(image);
    }

    public void addImage(String imagePath, float scalePercentX, float scalePercentY, int xPosition, int offsetFromTop, PDFAlign alignment) throws IOException, BadElementException, DocumentException {
        int yPosition = (int)this.getHeight() - offsetFromTop;
        Image image = Image.getInstance((URL)ClasspathUtility.getUrlPath(imagePath));
        image.scalePercent(scalePercentX, scalePercentY);
        image.setAbsolutePosition((float)xPosition, (float)yPosition);
        image.setAlignment(alignment.value());
        this.content.addImage(image);
    }
}

