/*
 * Decompiled with CFR 0.152.
 */
package zen.pdf;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import zen.logging.interfaces.ILogging;
import zen.pdf.PDFPage;

public class PDFDocument
implements ILogging {
    private transient int counter;
    private transient PdfWriter writer;
    private transient Document document;

    public PDFDocument(String path) {
        try {
            this.initialize(new FileOutputStream(path));
        }
        catch (FileNotFoundException exception) {
            LOG.error(this.getClass(), exception.toString(), exception);
        }
    }

    public PDFDocument(File file) {
        try {
            this.initialize(new FileOutputStream(file));
        }
        catch (FileNotFoundException exception) {
            LOG.error(this.getClass(), exception.toString(), exception);
        }
    }

    public PDFPage newPDFPage() throws DocumentException {
        ++this.counter;
        if (this.counter > 1) {
            this.document.add((Element)Chunk.NEXTPAGE);
        }
        return new PDFPage(this.writer, this.document);
    }

    private void initialize(FileOutputStream stream) {
        try {
            this.document = new Document();
            this.writer = PdfWriter.getInstance((Document)this.document, (OutputStream)stream);
        }
        catch (DocumentException exception) {
            LOG.error(this.getClass(), exception.toString(), exception);
        }
    }

    public void open() {
        this.document.open();
    }

    public void close() {
        this.document.close();
    }
}

