/*
 * Decompiled with CFR 0.152.
 */
package zen.object;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import zen.object.ObjectException;
import zen.string.StringUtility;
import zen.utility.Utility;

public final class ObjectUtility
extends Utility {
    private static final long serialVersionUID = 8250949864352986524L;
    private static final String GET = "get";
    private static final String SET = "set";
    private static final String PERIOD = ".";

    private ObjectUtility() {
    }

    public static Object createInstance(String instance) throws ObjectException {
        try {
            return Class.forName(instance).newInstance();
        }
        catch (IllegalAccessException exception) {
            throw new ObjectException("Class [" + instance + "] could not be accessed.", exception);
        }
        catch (InstantiationException exception) {
            throw new ObjectException("Class [" + instance + "] could not be instantiated.", exception);
        }
        catch (ClassNotFoundException exception) {
            throw new ObjectException("Class [" + instance + "] could not be found on the classpath.", exception);
        }
        catch (Exception exception) {
            throw new ObjectException("Exception [" + exception.toString() + "] occured while trying to create an instance of Class [" + instance + "]", exception);
        }
    }

    public static void setMethodValue(Object obj, Object[] values, String fullPath) throws ObjectException {
        try {
            Method method = null;
            String[] elements = StringUtility.split(fullPath, PERIOD);
            Object object = obj;
            if (elements.length == 1) {
                Class<?> superClass = object.getClass();
                method = ObjectUtility.getMethod(superClass, fullPath, false);
                if (method != null) {
                    method.invoke(object, values);
                }
                ObjectUtility.setSuperClassMethod(superClass, object, values, fullPath);
            } else {
                ObjectUtility.setChildClassMethod(elements, object, values);
            }
        }
        catch (InvocationTargetException exception) {
            throw new ObjectException(String.valueOf(fullPath) + " could not be invoked on Object [" + obj.getClass().getName() + "]", exception);
        }
        catch (IllegalAccessException exception) {
            throw new ObjectException(String.valueOf(fullPath) + " could not be accessed on Object [" + obj.getClass().getName() + "]", exception);
        }
        catch (Exception exception) {
            throw new ObjectException("Some error occured when trying to access/invoke Method [" + fullPath + "] on Object [" + obj.getClass().getName() + "]", exception);
        }
    }

    private static void setSuperClassMethod(Class child, Object object, Object[] values, String fullPath) throws InvocationTargetException, IllegalAccessException {
        Class superClass = child;
        while ((superClass = superClass.getSuperclass()) != null) {
            Method method = ObjectUtility.getMethod(superClass, fullPath, false);
            if (method == null) continue;
            method.invoke(object, values);
        }
    }

    private static void setChildClassMethod(String[] elements, Object object, Object[] values) throws InvocationTargetException, IllegalAccessException {
        Object thisObject = object;
        int i = 0;
        while (i < elements.length) {
            Method method = ObjectUtility.getMethod(thisObject.getClass(), elements[i], false);
            if (i == elements.length - 1) {
                method.invoke(thisObject, values);
            } else {
                Object newObject = method.invoke(thisObject, null);
                if (newObject != null) {
                    thisObject = newObject;
                }
            }
            ++i;
        }
    }

    public static Object getMethodValue(Object obj, String fullPath) throws ObjectException {
        try {
            Method method = null;
            String[] elements = StringUtility.split(fullPath, PERIOD);
            Object object = obj;
            if (elements.length == 1) {
                Class<?> superClass = object.getClass();
                method = ObjectUtility.getMethod(superClass, fullPath, true);
                if (method != null) {
                    return method.invoke(object, null);
                }
                return ObjectUtility.getSuperClassMethod(superClass, object, null, fullPath);
            }
            return ObjectUtility.getChildClassMethod(elements, object, null);
        }
        catch (InvocationTargetException exception) {
            throw new ObjectException("Method [" + fullPath + "] could not be invoked on Object [" + obj.getClass().getName() + "]", exception);
        }
        catch (IllegalAccessException exception) {
            throw new ObjectException("Method [" + fullPath + "] could not be accessed on Object [" + obj.getClass().getName() + "]", exception);
        }
        catch (Exception exception) {
            throw new ObjectException("Some error occured when trying to access/invoke Method [" + fullPath + "] on Object [" + obj.getClass().getName() + "]", exception);
        }
    }

    private static Object getSuperClassMethod(Class child, Object object, Object[] values, String fullPath) throws InvocationTargetException, IllegalAccessException {
        Class superClass = child;
        while ((superClass = superClass.getSuperclass()) != null) {
            Method method = ObjectUtility.getMethod(superClass, fullPath, true);
            if (method == null) continue;
            return method.invoke(object, values);
        }
        return null;
    }

    private static Object getChildClassMethod(String[] elements, Object object, Object[] values) throws InvocationTargetException, IllegalAccessException {
        Object thisObject = object;
        int i = 0;
        while (i < elements.length) {
            Method method = ObjectUtility.getMethod(thisObject.getClass(), elements[i], true);
            if (i == elements.length - 1) {
                return method.invoke(thisObject, null);
            }
            Object newObject = method.invoke(thisObject, values);
            if (newObject != null) {
                thisObject = newObject;
            }
            ++i;
        }
        return null;
    }

    private static String formatPropertyName(String propertyName, boolean getter) {
        if (getter) {
            if (!propertyName.startsWith(GET) && !StringUtility.isEmpty(propertyName)) {
                return GET + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
            }
        } else if (!propertyName.startsWith(SET) && !StringUtility.isEmpty(propertyName)) {
            return SET + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        }
        return propertyName;
    }

    private static Method getMethod(Class CLASS, String propertyName, boolean getter) {
        String methodName = ObjectUtility.formatPropertyName(propertyName, getter);
        Method[] methods = CLASS.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(methodName)) {
                methods[i].setAccessible(true);
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean isNull(Object object) {
        return object == null;
    }
}

