/*
 * Decompiled with CFR 0.152.
 */
package zen.logging;

import zen.common.AbstractFactory;
import zen.configuration.ConfigurationException;
import zen.configuration.ConfigurationReader;
import zen.logging.Configurations;
import zen.logging.interfaces.ILogger;
import zen.object.ObjectException;
import zen.object.ObjectUtility;

public final class LoggerFactory
extends AbstractFactory {
    private static final long serialVersionUID = -3607976310791559582L;
    private static LoggerFactory instance;
    private transient ILogger logger;

    private LoggerFactory() {
        this.initialize();
    }

    private void initialize() {
        try {
            Configurations configurations = (Configurations)ConfigurationReader.loadConfigurations(Configurations.class);
            String implementation = configurations.getImplementation();
            this.logger = (ILogger)ObjectUtility.createInstance(implementation);
            this.logger.initialize();
            this.logger.info(LoggerFactory.class, "Loaded ILogger [" + implementation + "]");
        }
        catch (ConfigurationException e) {
            e.printStackTrace(System.out);
        }
        catch (ObjectException e) {
            e.printStackTrace(System.out);
        }
    }

    public static LoggerFactory getInstance() {
        if (instance == null) {
            instance = new LoggerFactory();
        }
        return instance;
    }

    public ILogger getLogger() {
        return this.logger;
    }
}

