/*
 * Decompiled with CFR 0.152.
 */
package zen.guid;

import java.rmi.dgc.VMID;
import java.util.Locale;
import zen.common.AbstractFactory;
import zen.guid.GUID;

public final class GUIDFactory
extends AbstractFactory {
    private static final long serialVersionUID = 2138911183438275298L;
    private static GUIDFactory instance;

    private GUIDFactory() {
    }

    public static GUIDFactory getInstance() {
        if (instance == null) {
            instance = new GUIDFactory();
        }
        return instance;
    }

    public GUID generate() {
        String vmid = new VMID().toString();
        String guid = this.buildGUID(vmid.toUpperCase(Locale.US));
        LOG.info(GUIDFactory.class, "GUID: " + guid);
        return new GUID(guid);
    }

    private String buildGUID(String vmid) {
        String converted = vmid.replaceAll(":", "").replaceAll("-", "");
        StringBuffer formatted = new StringBuffer();
        formatted.append(converted.substring(0, 8));
        formatted.append('-');
        formatted.append(converted.substring(8, 12));
        formatted.append('-');
        formatted.append(converted.substring(12, 16));
        formatted.append('-');
        formatted.append(converted.substring(16, 20));
        formatted.append('-');
        formatted.append(converted.substring(20));
        return formatted.toString();
    }
}

