/*
 * Decompiled with CFR 0.152.
 */
package zen.ejb;

import java.util.HashMap;
import java.util.Map;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import zen.common.AbstractFactory;
import zen.ejb.EJBException;
import zen.ejb.EJBUtility;
import zen.string.StringUtility;

public final class EJBFactory
extends AbstractFactory {
    private static final long serialVersionUID = 183341009102395179L;
    private static EJBFactory instance;
    private final transient Map<String, Object> homeInterfaces = new HashMap<String, Object>();

    private EJBFactory() {
    }

    public static EJBFactory getInstance() {
        if (instance == null) {
            instance = new EJBFactory();
        }
        return instance;
    }

    public EJBHome getHomeInterface(String jndiName, Class ejbHome) throws EJBException {
        if (StringUtility.isEmpty(jndiName)) {
            throw new EJBException("JNDI name was null or empty");
        }
        try {
            return this.getEJBHome(jndiName, ejbHome);
        }
        catch (Exception exception) {
            LOG.error(EJBFactory.class, exception.toString(), exception);
            throw new EJBException("An error occured while trying to get or create EJBHome for JNDI [" + jndiName + "]", exception);
        }
    }

    private EJBHome getEJBHome(String jndiName, Class ejbHome) throws EJBException {
        EJBHome home = null;
        if (this.homeInterfaces.containsKey(jndiName)) {
            home = (EJBHome)this.homeInterfaces.get(jndiName);
        } else {
            home = EJBUtility.getHomeInterface(jndiName, ejbHome);
            if (home == null) {
                throw new EJBException("Could not create EJBHome from JNDI [" + jndiName + "]");
            }
            this.homeInterfaces.put(jndiName, home);
        }
        return home;
    }

    public EJBLocalHome getLocalInterface(String jndiName) throws EJBException {
        if (StringUtility.isEmpty(jndiName)) {
            throw new EJBException("JNDI name was null or empty");
        }
        try {
            return this.getEJBLocalHome(jndiName);
        }
        catch (Exception exception) {
            LOG.error(EJBFactory.class, exception.toString(), exception);
            throw new EJBException("An error occured trying to get or create EJBLocalHome for JNDI [" + jndiName + "]", exception);
        }
    }

    private EJBLocalHome getEJBLocalHome(String jndiName) throws EJBException {
        EJBLocalHome home = null;
        if (this.homeInterfaces.containsKey(jndiName)) {
            home = (EJBLocalHome)this.homeInterfaces.get(jndiName);
        } else {
            home = EJBUtility.getLocalHomeInterface(jndiName);
            if (home == null) {
                throw new EJBException("Could not create EJBLocalHome from JNDI [" + jndiName + "]");
            }
            this.homeInterfaces.put(jndiName, home);
        }
        return home;
    }
}

