/*
 * Decompiled with CFR 0.152.
 */
package zen.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import zen.utility.Utility;

public final class DateUtility
extends Utility {
    private DateUtility() {
    }

    public static String format(String pattern, Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern, Locale.US);
        return sdf.format(date);
    }

    public static Date parse(String pattern, String date) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern, Locale.US);
            return sdf.parse(date);
        }
        catch (ParseException e) {
            LOG.error(DateUtility.class, e.toString(), e);
            return null;
        }
    }

    public static Date getZeroTimeDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static boolean isSameDay(Date date1, Date date2) {
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar1.setTime(date1);
        calendar2.setTime(date2);
        return DateUtility.isSameDay(calendar1, calendar2);
    }

    public static boolean isSameDay(Calendar date1, Calendar date2) {
        if (date1.get(1) != date2.get(1)) {
            return false;
        }
        if (date1.get(2) != date2.get(2)) {
            return false;
        }
        return date1.get(5) == date2.get(5);
    }
}

