/*
 * Decompiled with CFR 0.152.
 */
package zen.configuration;

import org.apache.log4j.Logger;
import zen.configuration.ConfigurationException;
import zen.configuration.IConfigurations;
import zen.xml.XmlDocument;
import zen.xml.XmlException;
import zen.xml.XmlNode;

public final class ConfigurationReader {
    private ConfigurationReader() {
    }

    public static IConfigurations loadConfigurations(Class configurations) throws ConfigurationException {
        try {
            IConfigurations iconfigurations = (IConfigurations)configurations.newInstance();
            ConfigurationReader.loadConfigurations(iconfigurations);
            return iconfigurations;
        }
        catch (IllegalAccessException exception) {
            throw new ConfigurationException("Class [" + configurations.getName() + "] could not be accessed.", exception);
        }
        catch (InstantiationException exception) {
            throw new ConfigurationException("Class [" + configurations.getName() + "] could not be instantiated.", exception);
        }
        catch (Exception exception) {
            throw new ConfigurationException("Some error occured while trying to create an instance of Class [" + configurations.getName() + "]", exception);
        }
    }

    public static void loadConfigurations(IConfigurations configurations) throws ConfigurationException {
        boolean loaded = false;
        XmlNode sections = ConfigurationReader.getDocument().getRoot().getChild("layers");
        for (XmlNode section : sections.getChildren("layer")) {
            String type = section.getAttribute("configuration");
            String name = section.getAttribute("name");
            if (!type.equals(configurations.getClass().getName())) continue;
            XmlNode node = ConfigurationReader.getDocument().getRoot().getChild(name);
            configurations.load(node);
            loaded = true;
        }
        if (!loaded) {
            throw new ConfigurationException("IConfigurations [" + configurations.getClass().getName() + "] not found as a 'layer' mapping in 'layers'");
        }
    }

    private static XmlDocument getDocument() throws ConfigurationException {
        XmlDocument document = ConfigurationReader.getDocument("/zen.xml");
        if (document == null) {
            document = ConfigurationReader.getDocument("zen.xml");
        }
        if (document != null) {
            return document;
        }
        throw new ConfigurationException("Error reading/loading XmlDocument for Configuration [zen.xml]");
    }

    private static XmlDocument getDocument(String path) {
        try {
            return new XmlDocument(path);
        }
        catch (XmlException exception) {
            Logger.getLogger((String)ConfigurationReader.class.getName()).warn((Object)exception.toString());
            return null;
        }
    }
}

