/*
 * Decompiled with CFR 0.152.
 */
package zen.configuration;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import zen.configuration.ConfigurationException;
import zen.configuration.IConfiguration;
import zen.file.FileUtility;
import zen.logging.interfaces.ILogging;
import zen.string.StringUtility;

public abstract class AbstractConfigure
implements ILogging {
    protected IConfiguration configure(IConfiguration configuration) throws ConfigurationException {
        Properties properties = this.loadProperties(configuration);
        this.populateConfiguration(configuration, properties);
        return configuration;
    }

    private Properties loadProperties(IConfiguration configuration) throws ConfigurationException {
        Properties properties = new Properties();
        String configFile = configuration.getPropertyFileName();
        try {
            File file = FileUtility.getFile(configFile);
            FileReader reader = new FileReader(file);
            properties.load(reader);
        }
        catch (UnsupportedEncodingException exception) {
            this.handleException(String.valueOf(configFile) + " encoding error while loading properties", exception);
        }
        catch (FileNotFoundException exception) {
            this.handleException(String.valueOf(configFile) + " file could not be found by reader", exception);
        }
        catch (IOException exception) {
            this.handleException(String.valueOf(configFile) + " IO problem while reading properties", exception);
        }
        catch (Exception exception) {
            this.handleException(String.valueOf(configFile) + " Unexpected problem while loading properties", exception);
        }
        return properties;
    }

    private void handleException(String message, Exception exception) throws ConfigurationException {
        LOG.fatal(this.getClass(), message, exception);
        throw new ConfigurationException(message, exception);
    }

    private void handleWarning(String message, Exception exception) {
        LOG.warn(this.getClass(), message, exception);
    }

    private void populateConfiguration(IConfiguration configuration, Properties properties) {
        for (Map.Entry<Object, Object> prop : properties.entrySet()) {
            this.populateConfiguration(prop, configuration);
        }
    }

    private void populateConfiguration(Map.Entry<Object, Object> prop, IConfiguration configuration) {
        Object field = null;
        try {
            StringBuffer propName = new StringBuffer(100);
            String propKey = (String)prop.getKey();
            if (propKey.indexOf(46) >= 0) {
                String[] propParts = propKey.split(".");
                propName.append(propParts[0].toLowerCase(Locale.US));
                int i = 1;
                while (i < propParts.length) {
                    propName.append(this.camelCase(propParts[i]));
                    ++i;
                }
            } else {
                propName.append(propKey);
            }
            field = configuration.getClass().getDeclaredField(propName.toString());
            ((Field)field).setAccessible(true);
            if (((Field)field).getType().getSimpleName().equals("String")) {
                ((Field)field).set(configuration, prop.getValue());
            }
        }
        catch (NoSuchFieldException exception) {
            this.handleWarning(String.valueOf((String)prop.getKey()) + " does not exist on " + configuration.getClass().getSimpleName() + ".", exception);
        }
        catch (IllegalAccessException exception) {
            this.handleWarning(String.valueOf((String)prop.getKey()) + " of type " + field.getClass().getName() + " is inaccessible.", exception);
        }
    }

    private String camelCase(String string) {
        StringBuffer value = new StringBuffer(10);
        if (StringUtility.isEmpty(string)) {
            value.append("");
        } else if (string.length() == 1) {
            value.append(string.toUpperCase(Locale.US));
        } else {
            value.append(String.valueOf(string.substring(0, 1).toUpperCase(Locale.US)) + string.substring(1).toLowerCase(Locale.US));
        }
        return value.toString();
    }
}

