/*
 * Decompiled with CFR 0.152.
 */
package zen.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import zen.common.AbstractTransport;
import zen.common.Error;
import zen.common.Message;

public abstract class AbstractResponse
extends AbstractTransport {
    private static final long serialVersionUID = 2273937954769031184L;
    private final transient List<Message> messages = new ArrayList<Message>();

    protected AbstractResponse() {
    }

    public void addMessage(Message message) {
        this.messages.add(message);
    }

    public void addMessages(AbstractResponse response) {
        this.addMessages(response.getMessages());
    }

    public void addMessages(List<Message> messages) {
        Iterator<Message> iterator = messages.iterator();
        while (iterator.hasNext()) {
            this.addMessage(iterator.next());
        }
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public boolean hasErrors() {
        boolean flag = false;
        int i = 0;
        while (i < this.messages.size()) {
            Message message = this.messages.get(i);
            if (message instanceof Error) {
                flag = true;
            }
            ++i;
        }
        return flag;
    }

    public List<Message> getErrors() {
        ArrayList<Message> errors = new ArrayList<Message>();
        int i = 0;
        while (i < this.messages.size()) {
            Message message = this.messages.get(i);
            if (message instanceof Error) {
                errors.add(message);
            }
            ++i;
        }
        return errors;
    }

    public boolean hasMessages() {
        return !this.messages.isEmpty();
    }
}

