/*
 * Decompiled with CFR 0.152.
 */
package zen.classpath;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;
import zen.utility.Utility;

public final class ClasspathUtility
extends Utility {
    private static final String WEB_INF_CLASSES = "/WEB-INF/classes";
    private static final String WEB_INF_LIB = "/WEB-INF/lib";

    private ClasspathUtility() {
    }

    public static URL getUrlPath(String path) {
        URL url = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            url = loader.getResource(path);
        }
        if (url == null) {
            url = ClasspathUtility.class.getResource(path);
        }
        Logger.getLogger((String)ClasspathUtility.class.getName()).debug((Object)("#### ClasspathUtility URL Path: " + url.toString()));
        return url;
    }

    public static InputStream getInputStream(String path) {
        try {
            URL url = ClasspathUtility.getUrlPath(path);
            if (url != null) {
                if (url.getPath().indexOf(".jar!") > -1) {
                    return ClasspathUtility.getResourceFromJar(path, url);
                }
                return url.openStream();
            }
        }
        catch (Exception exception) {
            Logger.getLogger((String)ClasspathUtility.class.getName()).warn((Object)exception.toString(), (Throwable)exception);
        }
        return null;
    }

    private static InputStream getResourceFromJar(String path, URL url) {
        try {
            String jarFile = url.getPath().substring("file:/".length(), url.getPath().indexOf("!"));
            File file = new File(URLDecoder.decode(jarFile, "UTF-8"));
            JarFile jar = new JarFile(file);
            return jar.getInputStream(jar.getEntry(path));
        }
        catch (UnsupportedEncodingException exception) {
            Logger.getLogger((String)ClasspathUtility.class.getName()).warn((Object)exception.toString(), (Throwable)exception);
        }
        catch (IOException exception) {
            Logger.getLogger((String)ClasspathUtility.class.getName()).warn((Object)exception.toString(), (Throwable)exception);
        }
        return null;
    }

    public static List<String> getAnnotatedClasses(Class annotation, List<String> packages) throws IOException, UnsupportedEncodingException {
        ArrayList<String> annotatedClasses = new ArrayList<String>();
        List<String> classes = ClasspathUtility.getClassesFromClasspath();
        for (String className : classes) {
            if (!ClasspathUtility.isIncluded(className, packages)) continue;
            ClasspathUtility.addAnnotatedClass(className, annotation, annotatedClasses);
        }
        return annotatedClasses;
    }

    private static void addAnnotatedClass(String className, Class annotation, List<String> annotatedClasses) {
        try {
            Class<?> classImpl = Class.forName(className);
            if (ClasspathUtility.isAnnotationPresent(classImpl, annotation)) {
                annotatedClasses.add(className);
            }
        }
        catch (ClassNotFoundException exception) {
            Logger.getLogger((String)ClasspathUtility.class.getName()).warn((Object)exception.toString());
        }
    }

    public static List<String> getInterfaceClasses(Class interfaceClass, List<String> packages) throws IOException, UnsupportedEncodingException {
        ArrayList<String> interfaceClasses = new ArrayList<String>();
        List<String> classes = ClasspathUtility.getClassesFromClasspath();
        for (String className : classes) {
            if (!ClasspathUtility.isIncluded(className, packages)) continue;
            ClasspathUtility.addInterfaceClass(className, interfaceClass, interfaceClasses);
        }
        return interfaceClasses;
    }

    private static void addInterfaceClass(String className, Class interfaceClass, List<String> interfaceClasses) {
        try {
            Class<?> implClass = Class.forName(className);
            if (ClasspathUtility.hasInterface(implClass, interfaceClass)) {
                interfaceClasses.add(implClass.getName());
            }
        }
        catch (ClassNotFoundException exception) {
            Logger.getLogger((String)ClasspathUtility.class.getName()).warn((Object)exception.toString());
        }
    }

    public static boolean hasInterface(Class implClass, Class interfaceClass) {
        Class<?>[] implInterfaces;
        Class<?>[] classArray = implInterfaces = implClass.getInterfaces();
        int n = implInterfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> implInterface = classArray[n2];
            if (implInterface.getName().equals(interfaceClass.getName())) {
                return true;
            }
            ++n2;
        }
        if (implClass.getSuperclass() != null) {
            return ClasspathUtility.hasInterface(implClass.getSuperclass(), interfaceClass);
        }
        return false;
    }

    public static List<String> getSubClasses(Class parentClass, List<String> packages) throws IOException, UnsupportedEncodingException {
        ArrayList<String> parentClasses = new ArrayList<String>();
        List<String> classes = ClasspathUtility.getClassesFromClasspath();
        for (String className : classes) {
            if (!ClasspathUtility.isIncluded(className, packages)) continue;
            ClasspathUtility.addSubClass(className, parentClass, parentClasses);
        }
        return parentClasses;
    }

    private static void addSubClass(String className, Class parentClass, List<String> parentClasses) {
        try {
            Class<?> implClass = Class.forName(className);
            if (ClasspathUtility.hasParentClass(implClass, parentClass)) {
                parentClasses.add(implClass.getName());
            }
        }
        catch (ClassNotFoundException exception) {
            Logger.getLogger((String)ClasspathUtility.class.getName()).warn((Object)exception.toString());
        }
    }

    public static boolean hasParentClass(Class implClass, Class parentClass) {
        Class CLASS = implClass;
        while ((CLASS = CLASS.getSuperclass()) != null) {
            if (!CLASS.getName().equals(parentClass.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnnotationPresent(Class implClass, Class annotation) {
        boolean flag = false;
        try {
            if (implClass.isAnnotationPresent(annotation)) {
                flag = true;
            }
        }
        catch (Exception exception) {
            Logger.getLogger((String)ClasspathUtility.class.getName()).info((Object)"exception was thrown, but is being ignored");
        }
        return flag;
    }

    private static boolean isIncluded(String className, List<String> packages) {
        if (packages != null && !packages.isEmpty()) {
            for (String packageName : packages) {
                if (className.indexOf(packageName) <= -1) continue;
                return true;
            }
        }
        return false;
    }

    private static List<String> getClassesFromClasspath() throws IOException, UnsupportedEncodingException {
        ArrayList<String> classes = new ArrayList<String>();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        for (File directory : ClasspathUtility.getClasspaths(loader.getResources(""))) {
            ClasspathUtility.getClassesFromClasspath(directory, directory, classes);
        }
        return classes;
    }

    private static void getClassesFromClasspath(File root, File directory, List<String> classes) throws IOException, UnsupportedEncodingException {
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].getName().endsWith(".class")) {
                String path = files[i].getPath();
                String className = path.substring(root.getPath().length() + 1).replace('\\', '/');
                classes.add(ClasspathUtility.getQualifiedClassName(className));
            } else if (files[i].getName().endsWith(".jar")) {
                classes.addAll(ClasspathUtility.getClassesFromLibrary(files[i].getPath()));
            } else if (files[i].isDirectory()) {
                ClasspathUtility.getClassesFromClasspath(root, files[i], classes);
            }
            ++i;
        }
    }

    private static List<String> getClassesFromLibrary(String library) throws IOException, UnsupportedEncodingException {
        ArrayList<String> classes = new ArrayList<String>();
        JarFile jar = new JarFile(library);
        Enumeration<JarEntry> enumeration = jar.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry entry = enumeration.nextElement();
            if (!entry.getName().endsWith(".class")) continue;
            String className = ClasspathUtility.getQualifiedClassName(entry.getName());
            classes.add(className);
        }
        return classes;
    }

    private static List<File> getClasspaths(Enumeration<URL> enumeration) throws UnsupportedEncodingException {
        ArrayList<File> classpaths = new ArrayList<File>();
        while (enumeration.hasMoreElements()) {
            URL resource = enumeration.nextElement();
            ClasspathUtility.addClassPath(resource, classpaths);
        }
        return classpaths;
    }

    private static void addClassPath(URL resource, List<File> classpaths) throws UnsupportedEncodingException {
        File dir = new File(URLDecoder.decode(resource.getFile(), "UTF-8"));
        String path = dir.getPath().replace('\\', '/');
        int index = path.indexOf(WEB_INF_CLASSES);
        if (index > -1) {
            File lib = new File(String.valueOf(path.substring(0, index)) + WEB_INF_LIB);
            classpaths.add(dir);
            classpaths.add(lib);
        } else {
            classpaths.add(dir);
        }
    }

    private static String getQualifiedClassName(String file) {
        return file.substring(0, file.indexOf(".class")).replace('/', '.');
    }
}

