/*
 * Decompiled with CFR 0.152.
 */
package zen.cache.implementations;

import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import zen.cache.interfaces.ICacheAdapter;
import zen.common.AbstractAdapter;

public class OSCacheAdapter
extends AbstractAdapter
implements ICacheAdapter {
    private transient GeneralCacheAdministrator administrator;

    @Override
    public void initialize() {
        this.administrator = new GeneralCacheAdministrator();
    }

    @Override
    public Object get(String key) {
        Object object = null;
        try {
            object = this.administrator.getFromCache(key);
        }
        catch (NeedsRefreshException e) {
            LOG.warn(OSCacheAdapter.class, "Key [" + key + "] does not exist in the Cache.");
        }
        return object;
    }

    @Override
    public boolean contains(String key) {
        boolean flag = false;
        try {
            flag = this.administrator.getFromCache(key) != null;
        }
        catch (NeedsRefreshException e) {
            LOG.warn(OSCacheAdapter.class, "Key [" + key + "] does not exist in the Cache.");
        }
        return flag;
    }

    @Override
    public void put(String key, Object object) {
        this.administrator.putInCache(key, object);
    }

    @Override
    public void remove(String key) {
        this.administrator.removeEntry(key);
    }

    @Override
    public void refresh() {
        this.administrator.flushAll();
    }
}

