/*
 * Decompiled with CFR 0.152.
 */
package zen.cache;

import zen.cache.Configurations;
import zen.cache.interfaces.ICacheAdapter;
import zen.common.AbstractFactory;
import zen.configuration.ConfigurationException;
import zen.configuration.ConfigurationReader;
import zen.object.ObjectException;
import zen.object.ObjectUtility;

public final class CacheFactory
extends AbstractFactory {
    private static final long serialVersionUID = 165803072454626974L;
    private static CacheFactory instance;
    private transient ICacheAdapter adapter;

    private CacheFactory() {
        this.initialize();
    }

    private void initialize() {
        try {
            Configurations configurations = (Configurations)ConfigurationReader.loadConfigurations(Configurations.class);
            String implementation = configurations.getImplementation();
            this.adapter = (ICacheAdapter)ObjectUtility.createInstance(implementation);
            this.adapter.initialize();
            LOG.info(CacheFactory.class, "Loaded ICacheAdapter [" + implementation + "]");
        }
        catch (ConfigurationException e) {
            LOG.error(CacheFactory.class, "Error reading configuration for cache: " + e.getMessage(), e);
        }
        catch (ObjectException e) {
            LOG.error(CacheFactory.class, "Error creating instance of ICacheAdapter", e);
        }
    }

    public static CacheFactory getInstance() {
        if (instance == null) {
            instance = new CacheFactory();
        }
        return instance;
    }

    public ICacheAdapter getCache() {
        return this.adapter;
    }
}

