/*
 * Decompiled with CFR 0.152.
 */
package zen.business.abstracts;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import zen.business.abstracts.AbstractBusinessTransformer;
import zen.business.interfaces.IBusinessObject;
import zen.business.interfaces.IDataObject;
import zen.logging.interfaces.ILogging;

public abstract class AbstractCollectionSynchronizer
implements ILogging {
    protected AbstractBusinessTransformer transformer;

    protected abstract String getBusinessObjectID(IBusinessObject var1);

    protected abstract String getDataObjectID(IDataObject var1);

    protected abstract IDataObject getTransformation(IBusinessObject var1, IDataObject var2);

    protected abstract void set(IDataObject var1, IBusinessObject var2);

    public List<IDataObject> synchronize(Set<IDataObject> set, List<IBusinessObject> list, IDataObject dataObject) {
        ArrayList<IDataObject> deleted = new ArrayList<IDataObject>(0);
        try {
            if (set != null) {
                this.saveupdate(set, list, dataObject);
                deleted.addAll(this.remove(set, list));
            }
        }
        catch (Exception ex) {
            LOG.error(this.getClass(), "synchronize: " + ex.toString(), ex);
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveupdate(Set<IDataObject> set, List<IBusinessObject> list, IDataObject dataObject) {
        block7: {
            try {
                if (set == null || list == null) break block7;
                for (IBusinessObject business : list) {
                    boolean isNew = true;
                    for (IDataObject data : set) {
                        if (!this.getDataObjectID(data).equals(this.getBusinessObjectID(business))) continue;
                        this.set(data, business);
                        isNew = false;
                        break;
                    }
                    if (!isNew) continue;
                    IDataObject newDataObject = this.getTransformation(business, dataObject);
                    Set<IDataObject> set2 = set;
                    synchronized (set2) {
                        set.add(newDataObject);
                    }
                    LOG.debug(this.getClass(), "#### Adding new IDataObject [" + newDataObject.getClass().getName() + "] ID [" + this.getDataObjectID(newDataObject) + "]");
                }
            }
            catch (Exception ex) {
                LOG.error(this.getClass(), "add: " + ex.toString(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IDataObject> remove(Set<IDataObject> set, List<IBusinessObject> list) {
        ArrayList<IDataObject> deleted;
        block7: {
            deleted = new ArrayList<IDataObject>(0);
            try {
                if (set == null || list == null) break block7;
                for (IDataObject dataObject : set) {
                    boolean isDeleted = true;
                    for (IBusinessObject businessObject : list) {
                        if (!this.getDataObjectID(dataObject).equals(this.getBusinessObjectID(businessObject))) continue;
                        isDeleted = false;
                        break;
                    }
                    if (!isDeleted) continue;
                    deleted.add(dataObject);
                    Set<IDataObject> set2 = set;
                    synchronized (set2) {
                        set.remove(dataObject);
                    }
                    LOG.debug(this.getClass(), "#### Removing new IDataObject [" + dataObject.getClass().getName() + "] ID [" + this.getDataObjectID(dataObject) + "]");
                }
            }
            catch (Exception ex) {
                LOG.error(this.getClass(), "remove: " + ex.toString(), ex);
            }
        }
        return deleted;
    }
}

