/*
 * Decompiled with CFR 0.152.
 */
package zen.business;

import zen.business.ConventionMemento;
import zen.business.abstracts.AbstractBusinessService;
import zen.business.interfaces.IBusinessConvention;
import zen.classpath.ClasspathUtility;
import zen.logging.interfaces.ILogging;

public class ServiceConvention
implements IBusinessConvention,
ILogging {
    @Override
    public void validate(ConventionMemento memento) {
        try {
            Class<?> classImpl;
            if (!memento.getServiceName().endsWith("Service")) {
                memento.addMessage(String.valueOf(memento.getServiceName()) + " should end with " + "Service");
            }
            if (!ClasspathUtility.hasParentClass(classImpl = Class.forName(memento.getServiceName(), false, Thread.currentThread().getContextClassLoader()), AbstractBusinessService.class)) {
                memento.addMessage(String.valueOf(memento.getServiceName()) + " does not implement " + AbstractBusinessService.class.getName());
            }
        }
        catch (Exception ex) {
            memento.addMessage(String.valueOf(memento.getServiceName()) + " could not be instantiated:\n\t" + ex.toString());
        }
    }
}

