/*
 * Decompiled with CFR 0.152.
 */
package zen.business;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import zen.string.StringUtility;

public class ConventionMemento
implements Serializable {
    private static final long serialVersionUID = 7584713663105197464L;
    private String serviceName;
    private String requestName;
    private String responseName;
    private final transient List<String> messages = new ArrayList<String>();

    public ConventionMemento(String serviceName) {
        if (!StringUtility.isEmpty(serviceName) && serviceName.indexOf("Service") > -1) {
            String baseName = serviceName.substring(0, serviceName.indexOf("Service"));
            this.requestName = String.valueOf(baseName) + "Request";
            this.responseName = String.valueOf(baseName) + "Response";
            this.serviceName = serviceName;
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getRequestName() {
        return this.requestName;
    }

    public void setRequestName(String requestName) {
        this.requestName = requestName;
    }

    public String getResponseName() {
        return this.responseName;
    }

    public void setResponseName(String responseName) {
        this.responseName = responseName;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public void addMessage(String message) {
        this.messages.add(message);
    }
}

