/*
 * Decompiled with CFR 0.152.
 */
package zen.business;

import java.util.ArrayList;
import java.util.List;
import zen.configuration.IConfigurations;
import zen.logging.interfaces.ILogging;
import zen.xml.XmlNode;

public class Configurations
implements IConfigurations,
ILogging {
    private static final long serialVersionUID = -4243702089297511792L;
    private final transient List<String> conventions = new ArrayList<String>();
    private final transient List<String> services = new ArrayList<String>();

    @Override
    public void load(XmlNode parent) {
        this.getConventions(parent);
        this.getServices(parent);
    }

    private void getConventions(XmlNode parent) {
        XmlNode child = parent.getChild("conventions");
        if (child == null) {
            LOG.debug(this.getClass(), "zen.xml contains no conventions tag.");
        } else {
            this.getPackages(this.conventions, child);
            this.validate(this.conventions, "conventions");
        }
    }

    private void getServices(XmlNode parent) {
        XmlNode child = parent.getChild("services");
        if (child == null) {
            LOG.debug(this.getClass(), "zen.xml contains no conventions tag.");
        } else {
            this.getPackages(this.services, child);
            this.validate(this.services, "services");
        }
    }

    private void validate(List<String> list, String TAG) {
        if (list == null || list.isEmpty()) {
            LOG.warn(this.getClass(), "zen.xml has a <" + TAG + "> tag with no valid <" + "package" + "> tags.");
        }
    }

    private void getPackages(List<String> list, XmlNode child) {
        List<XmlNode> packages = child.getChildren("package");
        if (packages != null && !packages.isEmpty()) {
            for (XmlNode grandchild : packages) {
                list.add(grandchild.getValue());
            }
        }
    }

    public List<String> getConventions() {
        return this.conventions;
    }

    public List<String> getServices() {
        return this.services;
    }
}

