/*
 * Decompiled with CFR 0.152.
 */
package zen.business;

import zen.business.BusinessError;
import zen.business.BusinessException;
import zen.business.BusinessMapping;
import zen.business.BusinessMappings;
import zen.business.abstracts.AbstractBusinessRequest;
import zen.business.abstracts.AbstractBusinessResponse;
import zen.business.abstracts.AbstractBusinessService;
import zen.logging.interfaces.ILogging;

public class BusinessController
implements ILogging {
    public final AbstractBusinessResponse consume(AbstractBusinessRequest request) throws BusinessException {
        if (request == null) {
            throw new BusinessException("Request was null!");
        }
        String requestName = request.getClass().getName();
        BusinessMapping mapping = BusinessMappings.getInstance().getMapping(requestName);
        if (mapping == null) {
            throw new BusinessException("Mapping not found for " + requestName);
        }
        return this.callService(request, mapping);
    }

    private final AbstractBusinessResponse callService(AbstractBusinessRequest request, BusinessMapping mapping) throws BusinessException {
        AbstractBusinessResponse response = null;
        AbstractBusinessService service = null;
        try {
            response = (AbstractBusinessResponse)Class.forName(mapping.getResponse()).newInstance();
            service = (AbstractBusinessService)Class.forName(mapping.getService()).newInstance();
            LOG.info(this.getClass(), this.getCallDetails(service, request, response));
            service.consume(request, response);
        }
        catch (IllegalAccessException exception) {
            this.handleException(exception, service, response);
        }
        catch (InstantiationException exception) {
            this.handleException(exception, service, response);
        }
        catch (ClassNotFoundException exception) {
            this.handleException(exception, service, response);
        }
        catch (Exception exception) {
            this.handleException(exception, service, response);
        }
        return response;
    }

    private final void handleException(Exception exception, AbstractBusinessService service, AbstractBusinessResponse response) throws BusinessException {
        if (response == null) {
            LOG.error(this.getClass(), exception.toString(), exception);
            throw new BusinessException("Error calling service: " + exception.toString(), exception);
        }
        LOG.error(this.getClass(), "Service [" + service.getClass().getName() + "] Error [" + exception.toString() + "]", exception);
        response.addMessage(new BusinessError(exception.toString()));
    }

    private final String getCallDetails(AbstractBusinessService service, AbstractBusinessRequest request, AbstractBusinessResponse response) {
        StringBuffer statement = new StringBuffer(100);
        statement.append("Service Call To ");
        statement.append(service.getClass().getName());
        statement.append(".consume(");
        statement.append(request.getClass().getName());
        statement.append(", ");
        statement.append(response.getClass().getName());
        statement.append(')');
        return statement.toString();
    }
}

