package zen.xml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class XmlNode implements Serializable
{
	private static final long serialVersionUID = -7265125702721282800L;
	private String name;
    private String value;
    private final transient Map<String, String> attributes = new HashMap<String, String>();
    private final transient List<XmlNode> children = new ArrayList<XmlNode>();
    
    public XmlNode()
    {
    	super();
    	
    	//Empty constructor
    }
    
    public XmlNode(final String name)
    {
    	this.name = name;
    }
    
    public XmlNode(final String name, final String value)
    {
    	this.name = name;
    	this.value = value;
    }

    public String getName()
    {
        return name;
    }

    public void setName(final String name)
    {
        this.name = name;
    }

    public String getValue()
    {
        return value;
    }

    public void setValue(final String value)
    {
        this.value = value;
    }

    public void setAttribute(final String name, final String value)
    {
        attributes.put(name, value);
    }

    public String getAttribute(final String name)
    {
        if (attributes.containsKey(name))
        {
            return (String) attributes.get(name);
        }

        return null;
    }
    
    public Set<String> getAttributeNames()
    {
        return attributes.keySet();
    }

    public void addChild(final XmlNode node)
    {
        children.add(node);
    }

    public XmlNode getChild(final String name)
    {
    	final List<XmlNode> children = getChildren(name);

        if (!children.isEmpty())
        {
            return (XmlNode) children.get(0);
        }

        return null;
    }

    public List<XmlNode> getChildren()
    {
        return children;
    }

    public List<XmlNode> getChildren(final String name)
    {
        final List<XmlNode> list = new ArrayList<XmlNode>();

        for (int i = 0; i < children.size(); i++)
        {
        	final XmlNode node = (XmlNode) children.get(i);

            if (node.getName().equals(name))
            {
                list.add(node);
            }
        }

        return list;
    }
}
