package zen.xml;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;


public class XmlDocument implements Serializable
{
	private static final long serialVersionUID = -4944215480661086249L;
	private XmlNode root;

	public XmlDocument()
    {
		super();
		
		//Empty constructor
    }

	public XmlDocument(final File file) throws XmlException
    {
        XmlParser.load(file, this);
    }

    public XmlDocument(final InputStream stream) throws XmlException
    {
    	XmlParser.load(stream, this);
    }

    public XmlDocument(final String file) throws XmlException
    {
    	XmlParser.load(file, this);
    }
    
    public XmlDocument(final StringBuffer input) throws XmlException
    {
    	XmlParser.load(input, this);
    }

    public void setRoot(final XmlNode root)
    {
        this.root = root;
    }

    public XmlNode getRoot()
    {
        return root;
    }
    
    public XmlNode getNode(final String nodeName) throws XmlException
    {
    	final List<XmlNode> nodes = getNodes(nodeName);

        if (nodes.size() == 1)
        {
            return (XmlNode) nodes.get(0);
        }
        else
        {
            throw new XmlException("More than one Node [" + nodeName + "] found on Document [" + getRoot().getName() + "]. Only one was expected.");
        }
    }

    public List<XmlNode> getNodes(final String nodeName) throws XmlException
    {
    	final List<XmlNode> found = new ArrayList<XmlNode>();

        findNodes(getRoot(), nodeName, found);

        if (found.isEmpty())
        {
        	throw new XmlException("Node [" + nodeName + "] not found on Document [" + getRoot().getName() + "]");
            
        }

       	return found;
    }

    private void findNodes(final XmlNode xmlNode, final String nodeName, final List<XmlNode> found)
    {
    	final List<XmlNode> nodes = xmlNode.getChildren();

        for (int i = 0; i < nodes.size(); i++)
        {
        	final XmlNode node = (XmlNode) nodes.get(i);

            if (node.getName().equals(nodeName))
            {
                found.add(node);
            }
            else
            {
                findNodes(node, nodeName, found);
            }
        }
    }
}
