package zen.validation.interfaces;

/**
 * The contract for a Validation rule. The interface is simple, taking a String
 * and returning a boolean. One might argue that this interface is too simple
 * for a validation layer. However, if you consider the difference between what
 * is a validation and what is a business rule, and how to encourage developers
 * to separate validation from business logic, the simplicity of this interface
 * will start to make sense. 
 * 
 * For instance, is a client interface field required, is it a date, is it a valid
 * date, is it a number, is it a social security number, is a zip code. Such can be
 * classified as validations, as they are simple and not business specific.
 * 
 * If you start getting requirements for does these two dates represent a specific
 * date range, is password one the same as password two, is this number in the 
 * correct format. While these may seem simple, they are typically business 
 * specific, and one step more complicated than a simple generic edit. Such can
 * usually be identified as business rules and therefore belong on the business tier.
 * 
 * With that in mind, it was decided that any validation should be a simple edit
 * on a single field from the client interface, which is usually captured as a
 * String in most interface architectures anyways. Anything else, probably belongs
 * in the business tier and this interface contract encourages that thinking.
 * 
 * @author DCano
 *
 */
public interface IValidation {
	boolean isValid(String value);
}
