package zen.validation.interfaces;

import java.util.List;

import zen.common.Message;

/**
 * Interface for validation commands used to execute Loyalty Framework validation
 * from a plugin or other abstraction.<br/>
 * Usage Notes:<br/>
 * Use contructors to set the member values. For required members, throw InvalidValidateCommandException
 * @author ABurkholder
 */
public interface IValidateCommand
{

    /**
     * Call Validator.validate(app, optkey, set, pojo) from this method.
     * The parameter values for app, optkey and set should be set from 
     * the implementors constructor(s). <br/>
     * The pojo object is the object to be validated.<br/>
     * Returns a list of framework Message objects if any errors occurred.
     * @param pojo Object
     * @return list List
     */
    List<Message> execute(Object pojo);

    /**
     * Getter for the app name member.
     * This member should be required and should not be allowed to be null.
     * Set this value from the implementors constructor(s).
     * If this member is null or empty, throw InvalidValidateCommandException.
     * @return String
     */
    String getApp();

    /**
     * Getter for the optkey member.
     * This member can be left optional with a null or empty String value.
     * Set this value from the implementors constructor(s).
     * @return String
     */
    String getOptionKey();

    /**
     * Getter for the validation set member.
     * This member can be left optional with a null or empty String value.
     * Set this value from the implementors constructor(s).
     * @return String
     */
    String getValidationSet();

}
