package zen.validation.implementations;

import zen.validation.abstracts.AbstractValidation;

/**
 * Validates if string represents a valid Social Security Number.
 *
 * RegEx: ^\\d{3}-\\d{2}-\\d{4}$
 *
 * @author DCano
 *
 */
public class SocialSecurity extends AbstractValidation
{
    private final static String SSN_REGEX = "^\\d{3}-\\d{2}-\\d{4}$";

    public boolean isValid(final String value)
    {
        return matches(SSN_REGEX, value);
    }
}
